package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.TransferFlow;
import com.xforceplus.elephantarchives.service.ITransferFlowService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-01
 */
@RestController
public class TransferFlowController {

  @Autowired
  private ITransferFlowService transferFlowServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param transferFlow ${table.comment}
   * @return
   */
  @GetMapping("/transferflows" )
  public XfR getTransferFlows(XfPage page, TransferFlow transferFlow) {
    return XfR.ok(transferFlowServiceImpl.page(page, Wrappers.query(transferFlow)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/transferflows/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(transferFlowServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param transferFlow ${table.comment}
   * @return XfR
   */
  @PostMapping("/transferflows")
  public XfR save(@RequestBody TransferFlow transferFlow) {
     return XfR.ok(transferFlowServiceImpl.save(transferFlow));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param transferFlow ${table.comment}
   * @return XfR
   */
  @PutMapping("/transferflows/{id}")
  public XfR putUpdate(@RequestBody TransferFlow transferFlow,@PathVariable Long id) {
      transferFlow.setId(id);
      return XfR.ok(transferFlowServiceImpl.updateById(transferFlow));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param transferFlow ${table.comment}
   * @return XfR
   */
  @PatchMapping("/transferflows/{id}")
  public XfR patchUpdate(@RequestBody TransferFlow transferFlow,@PathVariable Long id) {
      TransferFlow uptransferFlow = transferFlowServiceImpl.getById(id);
      if(uptransferFlow != null){
        uptransferFlow = ObjectCopyUtils.copyProperties(transferFlow,uptransferFlow,true);
      }
      return XfR.ok(transferFlowServiceImpl.updateById(uptransferFlow));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/transferflows/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(transferFlowServiceImpl.removeById(id));
  }

  @PostMapping("/transferflows/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "transfer_flow");
     params.put("request", condition);

     return XfR.ok(transferFlowServiceImpl.querys(params));
  }

}
