package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.InventoryFlow;
import com.xforceplus.elephantarchives.service.IInventoryFlowService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-07
 */
@RestController
public class InventoryFlowController {

  @Autowired
  private IInventoryFlowService inventoryFlowServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param inventoryFlow ${table.comment}
   * @return
   */
  @GetMapping("/inventoryflows" )
  public XfR getInventoryFlows(XfPage page, InventoryFlow inventoryFlow) {
    return XfR.ok(inventoryFlowServiceImpl.page(page, Wrappers.query(inventoryFlow)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/inventoryflows/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(inventoryFlowServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param inventoryFlow ${table.comment}
   * @return XfR
   */
  @PostMapping("/inventoryflows")
  public XfR save(@RequestBody InventoryFlow inventoryFlow) {
     return XfR.ok(inventoryFlowServiceImpl.save(inventoryFlow));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param inventoryFlow ${table.comment}
   * @return XfR
   */
  @PutMapping("/inventoryflows/{id}")
  public XfR putUpdate(@RequestBody InventoryFlow inventoryFlow,@PathVariable Long id) {
      inventoryFlow.setId(id);
      return XfR.ok(inventoryFlowServiceImpl.updateById(inventoryFlow));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param inventoryFlow ${table.comment}
   * @return XfR
   */
  @PatchMapping("/inventoryflows/{id}")
  public XfR patchUpdate(@RequestBody InventoryFlow inventoryFlow,@PathVariable Long id) {
      InventoryFlow upinventoryFlow = inventoryFlowServiceImpl.getById(id);
      if(upinventoryFlow != null){
        upinventoryFlow = ObjectCopyUtils.copyProperties(inventoryFlow,upinventoryFlow,true);
      }
      return XfR.ok(inventoryFlowServiceImpl.updateById(upinventoryFlow));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/inventoryflows/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(inventoryFlowServiceImpl.removeById(id));
  }

  @PostMapping("/inventoryflows/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "inventory_flow");
     params.put("request", condition);

     return XfR.ok(inventoryFlowServiceImpl.querys(params));
  }

}
