package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.TicketMachineDetail;
import com.xforceplus.elephantarchives.service.ITicketMachineDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-07
 */
@RestController
public class TicketMachineDetailController {

  @Autowired
  private ITicketMachineDetailService ticketMachineDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketMachineDetail ${table.comment}
   * @return
   */
  @GetMapping("/ticketmachinedetails" )
  public XfR getTicketMachineDetails(XfPage page, TicketMachineDetail ticketMachineDetail) {
    return XfR.ok(ticketMachineDetailServiceImpl.page(page, Wrappers.query(ticketMachineDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketmachinedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketMachineDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketMachineDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketmachinedetails")
  public XfR save(@RequestBody TicketMachineDetail ticketMachineDetail) {
     return XfR.ok(ticketMachineDetailServiceImpl.save(ticketMachineDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketMachineDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketmachinedetails/{id}")
  public XfR putUpdate(@RequestBody TicketMachineDetail ticketMachineDetail,@PathVariable Long id) {
      ticketMachineDetail.setId(id);
      return XfR.ok(ticketMachineDetailServiceImpl.updateById(ticketMachineDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketMachineDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketmachinedetails/{id}")
  public XfR patchUpdate(@RequestBody TicketMachineDetail ticketMachineDetail,@PathVariable Long id) {
      TicketMachineDetail upticketMachineDetail = ticketMachineDetailServiceImpl.getById(id);
      if(upticketMachineDetail != null){
        upticketMachineDetail = ObjectCopyUtils.copyProperties(ticketMachineDetail,upticketMachineDetail,true);
      }
      return XfR.ok(ticketMachineDetailServiceImpl.updateById(upticketMachineDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketmachinedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketMachineDetailServiceImpl.removeById(id));
  }

  @PostMapping("/ticketmachinedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_machine_detail");
     params.put("request", condition);

     return XfR.ok(ticketMachineDetailServiceImpl.querys(params));
  }

}
