package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.Attachement;
import com.xforceplus.elephantarchives.service.IAttachementService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-20
 */
@RestController
public class AttachementController {

  @Autowired
  private IAttachementService attachementServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param attachement ${table.comment}
   * @return
   */
  @GetMapping("/attachements" )
  public XfR getAttachements(XfPage page, Attachement attachement) {
    return XfR.ok(attachementServiceImpl.page(page, Wrappers.query(attachement)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/attachements/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(attachementServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param attachement ${table.comment}
   * @return XfR
   */
  @PostMapping("/attachements")
  public XfR save(@RequestBody Attachement attachement) {
     return XfR.ok(attachementServiceImpl.save(attachement));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param attachement ${table.comment}
   * @return XfR
   */
  @PutMapping("/attachements/{id}")
  public XfR putUpdate(@RequestBody Attachement attachement,@PathVariable Long id) {
      attachement.setId(id);
      return XfR.ok(attachementServiceImpl.updateById(attachement));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param attachement ${table.comment}
   * @return XfR
   */
  @PatchMapping("/attachements/{id}")
  public XfR patchUpdate(@RequestBody Attachement attachement,@PathVariable Long id) {
      Attachement upattachement = attachementServiceImpl.getById(id);
      if(upattachement != null){
        upattachement = ObjectCopyUtils.copyProperties(attachement,upattachement,true);
      }
      return XfR.ok(attachementServiceImpl.updateById(upattachement));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/attachements/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(attachementServiceImpl.removeById(id));
  }

  @PostMapping("/attachements/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "attachement");
     params.put("request", condition);

     return XfR.ok(attachementServiceImpl.querys(params));
  }

}
