package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.BorrowOperateLog;
import com.xforceplus.elephantarchives.service.IBorrowOperateLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-20
 */
@RestController
public class BorrowOperateLogController {

  @Autowired
  private IBorrowOperateLogService borrowOperateLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param borrowOperateLog ${table.comment}
   * @return
   */
  @GetMapping("/borrowoperatelogs" )
  public XfR getBorrowOperateLogs(XfPage page, BorrowOperateLog borrowOperateLog) {
    return XfR.ok(borrowOperateLogServiceImpl.page(page, Wrappers.query(borrowOperateLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/borrowoperatelogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(borrowOperateLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param borrowOperateLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/borrowoperatelogs")
  public XfR save(@RequestBody BorrowOperateLog borrowOperateLog) {
     return XfR.ok(borrowOperateLogServiceImpl.save(borrowOperateLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param borrowOperateLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/borrowoperatelogs/{id}")
  public XfR putUpdate(@RequestBody BorrowOperateLog borrowOperateLog,@PathVariable Long id) {
      borrowOperateLog.setId(id);
      return XfR.ok(borrowOperateLogServiceImpl.updateById(borrowOperateLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param borrowOperateLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/borrowoperatelogs/{id}")
  public XfR patchUpdate(@RequestBody BorrowOperateLog borrowOperateLog,@PathVariable Long id) {
      BorrowOperateLog upborrowOperateLog = borrowOperateLogServiceImpl.getById(id);
      if(upborrowOperateLog != null){
        upborrowOperateLog = ObjectCopyUtils.copyProperties(borrowOperateLog,upborrowOperateLog,true);
      }
      return XfR.ok(borrowOperateLogServiceImpl.updateById(upborrowOperateLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/borrowoperatelogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(borrowOperateLogServiceImpl.removeById(id));
  }

  @PostMapping("/borrowoperatelogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "borrow_operate_log");
     params.put("request", condition);

     return XfR.ok(borrowOperateLogServiceImpl.querys(params));
  }

}
