package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.DirectoryRelation;
import com.xforceplus.elephantarchives.service.IDirectoryRelationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-20
 */
@RestController
public class DirectoryRelationController {

  @Autowired
  private IDirectoryRelationService directoryRelationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param directoryRelation ${table.comment}
   * @return
   */
  @GetMapping("/directoryrelations" )
  public XfR getDirectoryRelations(XfPage page, DirectoryRelation directoryRelation) {
    return XfR.ok(directoryRelationServiceImpl.page(page, Wrappers.query(directoryRelation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/directoryrelations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(directoryRelationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param directoryRelation ${table.comment}
   * @return XfR
   */
  @PostMapping("/directoryrelations")
  public XfR save(@RequestBody DirectoryRelation directoryRelation) {
     return XfR.ok(directoryRelationServiceImpl.save(directoryRelation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param directoryRelation ${table.comment}
   * @return XfR
   */
  @PutMapping("/directoryrelations/{id}")
  public XfR putUpdate(@RequestBody DirectoryRelation directoryRelation,@PathVariable Long id) {
      directoryRelation.setId(id);
      return XfR.ok(directoryRelationServiceImpl.updateById(directoryRelation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param directoryRelation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/directoryrelations/{id}")
  public XfR patchUpdate(@RequestBody DirectoryRelation directoryRelation,@PathVariable Long id) {
      DirectoryRelation updirectoryRelation = directoryRelationServiceImpl.getById(id);
      if(updirectoryRelation != null){
        updirectoryRelation = ObjectCopyUtils.copyProperties(directoryRelation,updirectoryRelation,true);
      }
      return XfR.ok(directoryRelationServiceImpl.updateById(updirectoryRelation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/directoryrelations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(directoryRelationServiceImpl.removeById(id));
  }

  @PostMapping("/directoryrelations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "directory_relation");
     params.put("request", condition);

     return XfR.ok(directoryRelationServiceImpl.querys(params));
  }

}
