package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.ArchiveIndex;
import com.xforceplus.elephantarchives.service.IArchiveIndexService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class ArchiveIndexController {

  @Autowired
  private IArchiveIndexService archiveIndexServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param archiveIndex ${table.comment}
   * @return
   */
  @GetMapping("/archiveindexs" )
  public XfR getArchiveIndexs(XfPage page, ArchiveIndex archiveIndex) {
    return XfR.ok(archiveIndexServiceImpl.page(page, Wrappers.query(archiveIndex)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/archiveindexs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(archiveIndexServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param archiveIndex ${table.comment}
   * @return XfR
   */
  @PostMapping("/archiveindexs")
  public XfR save(@RequestBody ArchiveIndex archiveIndex) {
     return XfR.ok(archiveIndexServiceImpl.save(archiveIndex));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param archiveIndex ${table.comment}
   * @return XfR
   */
  @PutMapping("/archiveindexs/{id}")
  public XfR putUpdate(@RequestBody ArchiveIndex archiveIndex,@PathVariable Long id) {
      archiveIndex.setId(id);
      return XfR.ok(archiveIndexServiceImpl.updateById(archiveIndex));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param archiveIndex ${table.comment}
   * @return XfR
   */
  @PatchMapping("/archiveindexs/{id}")
  public XfR patchUpdate(@RequestBody ArchiveIndex archiveIndex,@PathVariable Long id) {
      ArchiveIndex uparchiveIndex = archiveIndexServiceImpl.getById(id);
      if(uparchiveIndex != null){
        uparchiveIndex = ObjectCopyUtils.copyProperties(archiveIndex,uparchiveIndex,true);
      }
      return XfR.ok(archiveIndexServiceImpl.updateById(uparchiveIndex));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/archiveindexs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(archiveIndexServiceImpl.removeById(id));
  }

  @PostMapping("/archiveindexs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "archive_index");
     params.put("request", condition);

     return XfR.ok(archiveIndexServiceImpl.querys(params));
  }

}
