package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.BorrowApplyInfo;
import com.xforceplus.elephantarchives.service.IBorrowApplyInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class BorrowApplyInfoController {

  @Autowired
  private IBorrowApplyInfoService borrowApplyInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param borrowApplyInfo ${table.comment}
   * @return
   */
  @GetMapping("/borrowapplyinfos" )
  public XfR getBorrowApplyInfos(XfPage page, BorrowApplyInfo borrowApplyInfo) {
    return XfR.ok(borrowApplyInfoServiceImpl.page(page, Wrappers.query(borrowApplyInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/borrowapplyinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(borrowApplyInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param borrowApplyInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/borrowapplyinfos")
  public XfR save(@RequestBody BorrowApplyInfo borrowApplyInfo) {
     return XfR.ok(borrowApplyInfoServiceImpl.save(borrowApplyInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param borrowApplyInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/borrowapplyinfos/{id}")
  public XfR putUpdate(@RequestBody BorrowApplyInfo borrowApplyInfo,@PathVariable Long id) {
      borrowApplyInfo.setId(id);
      return XfR.ok(borrowApplyInfoServiceImpl.updateById(borrowApplyInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param borrowApplyInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/borrowapplyinfos/{id}")
  public XfR patchUpdate(@RequestBody BorrowApplyInfo borrowApplyInfo,@PathVariable Long id) {
      BorrowApplyInfo upborrowApplyInfo = borrowApplyInfoServiceImpl.getById(id);
      if(upborrowApplyInfo != null){
        upborrowApplyInfo = ObjectCopyUtils.copyProperties(borrowApplyInfo,upborrowApplyInfo,true);
      }
      return XfR.ok(borrowApplyInfoServiceImpl.updateById(upborrowApplyInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/borrowapplyinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(borrowApplyInfoServiceImpl.removeById(id));
  }

  @PostMapping("/borrowapplyinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "borrow_apply_info");
     params.put("request", condition);

     return XfR.ok(borrowApplyInfoServiceImpl.querys(params));
  }

}
