package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.ArchiveObjectExpand;
import com.xforceplus.elephantarchives.service.IArchiveObjectExpandService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-13
 */
@RestController
public class ArchiveObjectExpandController {

  @Autowired
  private IArchiveObjectExpandService archiveObjectExpandServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param archiveObjectExpand ${table.comment}
   * @return
   */
  @GetMapping("/archiveobjectexpands" )
  public XfR getArchiveObjectExpands(XfPage page, ArchiveObjectExpand archiveObjectExpand) {
    return XfR.ok(archiveObjectExpandServiceImpl.page(page, Wrappers.query(archiveObjectExpand)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/archiveobjectexpands/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(archiveObjectExpandServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param archiveObjectExpand ${table.comment}
   * @return XfR
   */
  @PostMapping("/archiveobjectexpands")
  public XfR save(@RequestBody ArchiveObjectExpand archiveObjectExpand) {
     return XfR.ok(archiveObjectExpandServiceImpl.save(archiveObjectExpand));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param archiveObjectExpand ${table.comment}
   * @return XfR
   */
  @PutMapping("/archiveobjectexpands/{id}")
  public XfR putUpdate(@RequestBody ArchiveObjectExpand archiveObjectExpand,@PathVariable Long id) {
      archiveObjectExpand.setId(id);
      return XfR.ok(archiveObjectExpandServiceImpl.updateById(archiveObjectExpand));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param archiveObjectExpand ${table.comment}
   * @return XfR
   */
  @PatchMapping("/archiveobjectexpands/{id}")
  public XfR patchUpdate(@RequestBody ArchiveObjectExpand archiveObjectExpand,@PathVariable Long id) {
      ArchiveObjectExpand uparchiveObjectExpand = archiveObjectExpandServiceImpl.getById(id);
      if(uparchiveObjectExpand != null){
        uparchiveObjectExpand = ObjectCopyUtils.copyProperties(archiveObjectExpand,uparchiveObjectExpand,true);
      }
      return XfR.ok(archiveObjectExpandServiceImpl.updateById(uparchiveObjectExpand));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/archiveobjectexpands/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(archiveObjectExpandServiceImpl.removeById(id));
  }

  @PostMapping("/archiveobjectexpands/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "archive_object_expand");
     params.put("request", condition);

     return XfR.ok(archiveObjectExpandServiceImpl.querys(params));
  }

}
