package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.AccountVoucher;
import com.xforceplus.elephantarchives.service.IAccountVoucherService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-27
 */
@RestController
public class AccountVoucherController {

  @Autowired
  private IAccountVoucherService accountVoucherServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param accountVoucher ${table.comment}
   * @return
   */
  @GetMapping("/accountvouchers" )
  public XfR getAccountVouchers(XfPage page, AccountVoucher accountVoucher) {
    return XfR.ok(accountVoucherServiceImpl.page(page, Wrappers.query(accountVoucher)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/accountvouchers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(accountVoucherServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param accountVoucher ${table.comment}
   * @return XfR
   */
  @PostMapping("/accountvouchers")
  public XfR save(@RequestBody AccountVoucher accountVoucher) {
     return XfR.ok(accountVoucherServiceImpl.save(accountVoucher));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param accountVoucher ${table.comment}
   * @return XfR
   */
  @PutMapping("/accountvouchers/{id}")
  public XfR putUpdate(@RequestBody AccountVoucher accountVoucher,@PathVariable Long id) {
      accountVoucher.setId(id);
      return XfR.ok(accountVoucherServiceImpl.updateById(accountVoucher));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param accountVoucher ${table.comment}
   * @return XfR
   */
  @PatchMapping("/accountvouchers/{id}")
  public XfR patchUpdate(@RequestBody AccountVoucher accountVoucher,@PathVariable Long id) {
      AccountVoucher upaccountVoucher = accountVoucherServiceImpl.getById(id);
      if(upaccountVoucher != null){
        upaccountVoucher = ObjectCopyUtils.copyProperties(accountVoucher,upaccountVoucher,true);
      }
      return XfR.ok(accountVoucherServiceImpl.updateById(upaccountVoucher));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/accountvouchers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(accountVoucherServiceImpl.removeById(id));
  }

  @PostMapping("/accountvouchers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "account_voucher");
     params.put("request", condition);

     return XfR.ok(accountVoucherServiceImpl.querys(params));
  }

}
