package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.BorrowApplyExamineLog;
import com.xforceplus.elephantarchives.service.IBorrowApplyExamineLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-27
 */
@RestController
public class BorrowApplyExamineLogController {

  @Autowired
  private IBorrowApplyExamineLogService borrowApplyExamineLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param borrowApplyExamineLog ${table.comment}
   * @return
   */
  @GetMapping("/borrowapplyexaminelogs" )
  public XfR getBorrowApplyExamineLogs(XfPage page, BorrowApplyExamineLog borrowApplyExamineLog) {
    return XfR.ok(borrowApplyExamineLogServiceImpl.page(page, Wrappers.query(borrowApplyExamineLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/borrowapplyexaminelogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(borrowApplyExamineLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param borrowApplyExamineLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/borrowapplyexaminelogs")
  public XfR save(@RequestBody BorrowApplyExamineLog borrowApplyExamineLog) {
     return XfR.ok(borrowApplyExamineLogServiceImpl.save(borrowApplyExamineLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param borrowApplyExamineLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/borrowapplyexaminelogs/{id}")
  public XfR putUpdate(@RequestBody BorrowApplyExamineLog borrowApplyExamineLog,@PathVariable Long id) {
      borrowApplyExamineLog.setId(id);
      return XfR.ok(borrowApplyExamineLogServiceImpl.updateById(borrowApplyExamineLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param borrowApplyExamineLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/borrowapplyexaminelogs/{id}")
  public XfR patchUpdate(@RequestBody BorrowApplyExamineLog borrowApplyExamineLog,@PathVariable Long id) {
      BorrowApplyExamineLog upborrowApplyExamineLog = borrowApplyExamineLogServiceImpl.getById(id);
      if(upborrowApplyExamineLog != null){
        upborrowApplyExamineLog = ObjectCopyUtils.copyProperties(borrowApplyExamineLog,upborrowApplyExamineLog,true);
      }
      return XfR.ok(borrowApplyExamineLogServiceImpl.updateById(upborrowApplyExamineLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/borrowapplyexaminelogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(borrowApplyExamineLogServiceImpl.removeById(id));
  }

  @PostMapping("/borrowapplyexaminelogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "borrow_apply_examine_log");
     params.put("request", condition);

     return XfR.ok(borrowApplyExamineLogServiceImpl.querys(params));
  }

}
