package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.ConfigAccountDataType;
import com.xforceplus.elephantarchives.service.IConfigAccountDataTypeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-27
 */
@RestController
public class ConfigAccountDataTypeController {

  @Autowired
  private IConfigAccountDataTypeService configAccountDataTypeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param configAccountDataType ${table.comment}
   * @return
   */
  @GetMapping("/configaccountdatatypes" )
  public XfR getConfigAccountDataTypes(XfPage page, ConfigAccountDataType configAccountDataType) {
    return XfR.ok(configAccountDataTypeServiceImpl.page(page, Wrappers.query(configAccountDataType)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/configaccountdatatypes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(configAccountDataTypeServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param configAccountDataType ${table.comment}
   * @return XfR
   */
  @PostMapping("/configaccountdatatypes")
  public XfR save(@RequestBody ConfigAccountDataType configAccountDataType) {
     return XfR.ok(configAccountDataTypeServiceImpl.save(configAccountDataType));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param configAccountDataType ${table.comment}
   * @return XfR
   */
  @PutMapping("/configaccountdatatypes/{id}")
  public XfR putUpdate(@RequestBody ConfigAccountDataType configAccountDataType,@PathVariable Long id) {
      configAccountDataType.setId(id);
      return XfR.ok(configAccountDataTypeServiceImpl.updateById(configAccountDataType));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param configAccountDataType ${table.comment}
   * @return XfR
   */
  @PatchMapping("/configaccountdatatypes/{id}")
  public XfR patchUpdate(@RequestBody ConfigAccountDataType configAccountDataType,@PathVariable Long id) {
      ConfigAccountDataType upconfigAccountDataType = configAccountDataTypeServiceImpl.getById(id);
      if(upconfigAccountDataType != null){
        upconfigAccountDataType = ObjectCopyUtils.copyProperties(configAccountDataType,upconfigAccountDataType,true);
      }
      return XfR.ok(configAccountDataTypeServiceImpl.updateById(upconfigAccountDataType));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/configaccountdatatypes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(configAccountDataTypeServiceImpl.removeById(id));
  }

  @PostMapping("/configaccountdatatypes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "config_account_data_type");
     params.put("request", condition);

     return XfR.ok(configAccountDataTypeServiceImpl.querys(params));
  }

}
