package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.Test0813;
import com.xforceplus.elephantarchives.service.ITest0813Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-27
 */
@RestController
public class Test0813Controller {

  @Autowired
  private ITest0813Service test0813ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test0813 ${table.comment}
   * @return
   */
  @GetMapping("/test0813s" )
  public XfR getTest0813s(XfPage page, Test0813 test0813) {
    return XfR.ok(test0813ServiceImpl.page(page, Wrappers.query(test0813)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/test0813s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test0813ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param test0813 ${table.comment}
   * @return XfR
   */
  @PostMapping("/test0813s")
  public XfR save(@RequestBody Test0813 test0813) {
     return XfR.ok(test0813ServiceImpl.save(test0813));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param test0813 ${table.comment}
   * @return XfR
   */
  @PutMapping("/test0813s/{id}")
  public XfR putUpdate(@RequestBody Test0813 test0813,@PathVariable Long id) {
      test0813.setId(id);
      return XfR.ok(test0813ServiceImpl.updateById(test0813));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param test0813 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/test0813s/{id}")
  public XfR patchUpdate(@RequestBody Test0813 test0813,@PathVariable Long id) {
      Test0813 uptest0813 = test0813ServiceImpl.getById(id);
      if(uptest0813 != null){
        uptest0813 = ObjectCopyUtils.copyProperties(test0813,uptest0813,true);
      }
      return XfR.ok(test0813ServiceImpl.updateById(uptest0813));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test0813s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test0813ServiceImpl.removeById(id));
  }

  @PostMapping("/test0813s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test0813");
     params.put("request", condition);

     return XfR.ok(test0813ServiceImpl.querys(params));
  }

}
