package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.Outsourcers;
import com.xforceplus.elephantarchives.service.IOutsourcersService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 外包商前端控制器
 *
 * @author ultraman
 * @date 2021-11-08
 */
@RestController
public class OutsourcersController {

  @Autowired
  private IOutsourcersService outsourcersServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param outsourcers 外包商
   * @return
   */
  @GetMapping("/outsourcerss" )
  public XfR getOutsourcerss(XfPage page, Outsourcers outsourcers) {
    return XfR.ok(outsourcersServiceImpl.page(page, Wrappers.query(outsourcers)));
  }

  /**
   * 通过id查询外包商
   * @param  id
   * @return XfR
   */
  @GetMapping("/outsourcerss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(outsourcersServiceImpl.getById(id));
  }

  /**
   * 新增外包商
   * @param outsourcers 外包商
   * @return XfR
   */
  @PostMapping("/outsourcerss")
  public XfR save(@RequestBody Outsourcers outsourcers) {
     return XfR.ok(outsourcersServiceImpl.save(outsourcers));
  }

  /**
   * 修改-传入修改后的全部数据外包商
   * @param outsourcers 外包商
   * @return XfR
   */
  @PutMapping("/outsourcerss/{id}")
  public XfR putUpdate(@RequestBody Outsourcers outsourcers,@PathVariable Long id) {
      outsourcers.setId(id);
      return XfR.ok(outsourcersServiceImpl.updateById(outsourcers));
  }

  /**
   * 修改-传入修改的数据外包商
   * @param outsourcers 外包商
   * @return XfR
   */
  @PatchMapping("/outsourcerss/{id}")
  public XfR patchUpdate(@RequestBody Outsourcers outsourcers,@PathVariable Long id) {
      Outsourcers upoutsourcers = outsourcersServiceImpl.getById(id);
      if(upoutsourcers != null){
        upoutsourcers = ObjectCopyUtils.copyProperties(outsourcers,upoutsourcers,true);
      }
      return XfR.ok(outsourcersServiceImpl.updateById(upoutsourcers));
  }

  /**
   * 通过id删除外包商
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/outsourcerss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(outsourcersServiceImpl.removeById(id));
  }

  @PostMapping("/outsourcerss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "outsourcers");
     params.put("request", condition);

     return XfR.ok(outsourcersServiceImpl.querys(params));
  }

}
