package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.StorageImport;
import com.xforceplus.elephantarchives.service.IStorageImportService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 待入库导入查询模板前端控制器
 *
 * @author ultraman
 * @date 2021-11-08
 */
@RestController
public class StorageImportController {

  @Autowired
  private IStorageImportService storageImportServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param storageImport 待入库导入查询模板
   * @return
   */
  @GetMapping("/storageimports" )
  public XfR getStorageImports(XfPage page, StorageImport storageImport) {
    return XfR.ok(storageImportServiceImpl.page(page, Wrappers.query(storageImport)));
  }

  /**
   * 通过id查询待入库导入查询模板
   * @param  id
   * @return XfR
   */
  @GetMapping("/storageimports/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(storageImportServiceImpl.getById(id));
  }

  /**
   * 新增待入库导入查询模板
   * @param storageImport 待入库导入查询模板
   * @return XfR
   */
  @PostMapping("/storageimports")
  public XfR save(@RequestBody StorageImport storageImport) {
     return XfR.ok(storageImportServiceImpl.save(storageImport));
  }

  /**
   * 修改-传入修改后的全部数据待入库导入查询模板
   * @param storageImport 待入库导入查询模板
   * @return XfR
   */
  @PutMapping("/storageimports/{id}")
  public XfR putUpdate(@RequestBody StorageImport storageImport,@PathVariable Long id) {
      storageImport.setId(id);
      return XfR.ok(storageImportServiceImpl.updateById(storageImport));
  }

  /**
   * 修改-传入修改的数据待入库导入查询模板
   * @param storageImport 待入库导入查询模板
   * @return XfR
   */
  @PatchMapping("/storageimports/{id}")
  public XfR patchUpdate(@RequestBody StorageImport storageImport,@PathVariable Long id) {
      StorageImport upstorageImport = storageImportServiceImpl.getById(id);
      if(upstorageImport != null){
        upstorageImport = ObjectCopyUtils.copyProperties(storageImport,upstorageImport,true);
      }
      return XfR.ok(storageImportServiceImpl.updateById(upstorageImport));
  }

  /**
   * 通过id删除待入库导入查询模板
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/storageimports/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(storageImportServiceImpl.removeById(id));
  }

  @PostMapping("/storageimports/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "storage_import");
     params.put("request", condition);

     return XfR.ok(storageImportServiceImpl.querys(params));
  }

}
