package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.ArchiveExceptionInfo;
import com.xforceplus.elephantarchives.service.IArchiveExceptionInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 档案异常信息表前端控制器
 *
 * @author ultraman
 * @date 2021-11-08
 */
@RestController
public class ArchiveExceptionInfoController {

  @Autowired
  private IArchiveExceptionInfoService archiveExceptionInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param archiveExceptionInfo 档案异常信息表
   * @return
   */
  @GetMapping("/archiveexceptioninfos" )
  public XfR getArchiveExceptionInfos(XfPage page, ArchiveExceptionInfo archiveExceptionInfo) {
    return XfR.ok(archiveExceptionInfoServiceImpl.page(page, Wrappers.query(archiveExceptionInfo)));
  }

  /**
   * 通过id查询档案异常信息表
   * @param  id
   * @return XfR
   */
  @GetMapping("/archiveexceptioninfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(archiveExceptionInfoServiceImpl.getById(id));
  }

  /**
   * 新增档案异常信息表
   * @param archiveExceptionInfo 档案异常信息表
   * @return XfR
   */
  @PostMapping("/archiveexceptioninfos")
  public XfR save(@RequestBody ArchiveExceptionInfo archiveExceptionInfo) {
     return XfR.ok(archiveExceptionInfoServiceImpl.save(archiveExceptionInfo));
  }

  /**
   * 修改-传入修改后的全部数据档案异常信息表
   * @param archiveExceptionInfo 档案异常信息表
   * @return XfR
   */
  @PutMapping("/archiveexceptioninfos/{id}")
  public XfR putUpdate(@RequestBody ArchiveExceptionInfo archiveExceptionInfo,@PathVariable Long id) {
      archiveExceptionInfo.setId(id);
      return XfR.ok(archiveExceptionInfoServiceImpl.updateById(archiveExceptionInfo));
  }

  /**
   * 修改-传入修改的数据档案异常信息表
   * @param archiveExceptionInfo 档案异常信息表
   * @return XfR
   */
  @PatchMapping("/archiveexceptioninfos/{id}")
  public XfR patchUpdate(@RequestBody ArchiveExceptionInfo archiveExceptionInfo,@PathVariable Long id) {
      ArchiveExceptionInfo uparchiveExceptionInfo = archiveExceptionInfoServiceImpl.getById(id);
      if(uparchiveExceptionInfo != null){
        uparchiveExceptionInfo = ObjectCopyUtils.copyProperties(archiveExceptionInfo,uparchiveExceptionInfo,true);
      }
      return XfR.ok(archiveExceptionInfoServiceImpl.updateById(uparchiveExceptionInfo));
  }

  /**
   * 通过id删除档案异常信息表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/archiveexceptioninfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(archiveExceptionInfoServiceImpl.removeById(id));
  }

  @PostMapping("/archiveexceptioninfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "archive_exception_info");
     params.put("request", condition);

     return XfR.ok(archiveExceptionInfoServiceImpl.querys(params));
  }

}
