package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.DirectoryExport;
import com.xforceplus.elephantarchives.service.IDirectoryExportService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 目录导出前端控制器
 *
 * @author ultraman
 * @date 2021-11-08
 */
@RestController
public class DirectoryExportController {

  @Autowired
  private IDirectoryExportService directoryExportServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param directoryExport 目录导出
   * @return
   */
  @GetMapping("/directoryexports" )
  public XfR getDirectoryExports(XfPage page, DirectoryExport directoryExport) {
    return XfR.ok(directoryExportServiceImpl.page(page, Wrappers.query(directoryExport)));
  }

  /**
   * 通过id查询目录导出
   * @param  id
   * @return XfR
   */
  @GetMapping("/directoryexports/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(directoryExportServiceImpl.getById(id));
  }

  /**
   * 新增目录导出
   * @param directoryExport 目录导出
   * @return XfR
   */
  @PostMapping("/directoryexports")
  public XfR save(@RequestBody DirectoryExport directoryExport) {
     return XfR.ok(directoryExportServiceImpl.save(directoryExport));
  }

  /**
   * 修改-传入修改后的全部数据目录导出
   * @param directoryExport 目录导出
   * @return XfR
   */
  @PutMapping("/directoryexports/{id}")
  public XfR putUpdate(@RequestBody DirectoryExport directoryExport,@PathVariable Long id) {
      directoryExport.setId(id);
      return XfR.ok(directoryExportServiceImpl.updateById(directoryExport));
  }

  /**
   * 修改-传入修改的数据目录导出
   * @param directoryExport 目录导出
   * @return XfR
   */
  @PatchMapping("/directoryexports/{id}")
  public XfR patchUpdate(@RequestBody DirectoryExport directoryExport,@PathVariable Long id) {
      DirectoryExport updirectoryExport = directoryExportServiceImpl.getById(id);
      if(updirectoryExport != null){
        updirectoryExport = ObjectCopyUtils.copyProperties(directoryExport,updirectoryExport,true);
      }
      return XfR.ok(directoryExportServiceImpl.updateById(updirectoryExport));
  }

  /**
   * 通过id删除目录导出
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/directoryexports/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(directoryExportServiceImpl.removeById(id));
  }

  @PostMapping("/directoryexports/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "directory_export");
     params.put("request", condition);

     return XfR.ok(directoryExportServiceImpl.querys(params));
  }

}
