package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.InventoryProcess;
import com.xforceplus.elephantarchives.service.IInventoryProcessService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 盘点过程表前端控制器
 *
 * @author ultraman
 * @date 2021-11-08
 */
@RestController
public class InventoryProcessController {

  @Autowired
  private IInventoryProcessService inventoryProcessServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param inventoryProcess 盘点过程表
   * @return
   */
  @GetMapping("/inventoryprocesss" )
  public XfR getInventoryProcesss(XfPage page, InventoryProcess inventoryProcess) {
    return XfR.ok(inventoryProcessServiceImpl.page(page, Wrappers.query(inventoryProcess)));
  }

  /**
   * 通过id查询盘点过程表
   * @param  id
   * @return XfR
   */
  @GetMapping("/inventoryprocesss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(inventoryProcessServiceImpl.getById(id));
  }

  /**
   * 新增盘点过程表
   * @param inventoryProcess 盘点过程表
   * @return XfR
   */
  @PostMapping("/inventoryprocesss")
  public XfR save(@RequestBody InventoryProcess inventoryProcess) {
     return XfR.ok(inventoryProcessServiceImpl.save(inventoryProcess));
  }

  /**
   * 修改-传入修改后的全部数据盘点过程表
   * @param inventoryProcess 盘点过程表
   * @return XfR
   */
  @PutMapping("/inventoryprocesss/{id}")
  public XfR putUpdate(@RequestBody InventoryProcess inventoryProcess,@PathVariable Long id) {
      inventoryProcess.setId(id);
      return XfR.ok(inventoryProcessServiceImpl.updateById(inventoryProcess));
  }

  /**
   * 修改-传入修改的数据盘点过程表
   * @param inventoryProcess 盘点过程表
   * @return XfR
   */
  @PatchMapping("/inventoryprocesss/{id}")
  public XfR patchUpdate(@RequestBody InventoryProcess inventoryProcess,@PathVariable Long id) {
      InventoryProcess upinventoryProcess = inventoryProcessServiceImpl.getById(id);
      if(upinventoryProcess != null){
        upinventoryProcess = ObjectCopyUtils.copyProperties(inventoryProcess,upinventoryProcess,true);
      }
      return XfR.ok(inventoryProcessServiceImpl.updateById(upinventoryProcess));
  }

  /**
   * 通过id删除盘点过程表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/inventoryprocesss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(inventoryProcessServiceImpl.removeById(id));
  }

  @PostMapping("/inventoryprocesss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "inventory_process");
     params.put("request", condition);

     return XfR.ok(inventoryProcessServiceImpl.querys(params));
  }

}
