package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.ArchiveFile;
import com.xforceplus.elephantarchives.service.IArchiveFileService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 三大类档案文件前端控制器
 *
 * @author ultraman
 * @date 2021-11-12
 */
@RestController
public class ArchiveFileController {

  @Autowired
  private IArchiveFileService archiveFileServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param archiveFile 三大类档案文件
   * @return
   */
  @GetMapping("/archivefiles" )
  public XfR getArchiveFiles(XfPage page, ArchiveFile archiveFile) {
    return XfR.ok(archiveFileServiceImpl.page(page, Wrappers.query(archiveFile)));
  }

  /**
   * 通过id查询三大类档案文件
   * @param  id
   * @return XfR
   */
  @GetMapping("/archivefiles/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(archiveFileServiceImpl.getById(id));
  }

  /**
   * 新增三大类档案文件
   * @param archiveFile 三大类档案文件
   * @return XfR
   */
  @PostMapping("/archivefiles")
  public XfR save(@RequestBody ArchiveFile archiveFile) {
     return XfR.ok(archiveFileServiceImpl.save(archiveFile));
  }

  /**
   * 修改-传入修改后的全部数据三大类档案文件
   * @param archiveFile 三大类档案文件
   * @return XfR
   */
  @PutMapping("/archivefiles/{id}")
  public XfR putUpdate(@RequestBody ArchiveFile archiveFile,@PathVariable Long id) {
      archiveFile.setId(id);
      return XfR.ok(archiveFileServiceImpl.updateById(archiveFile));
  }

  /**
   * 修改-传入修改的数据三大类档案文件
   * @param archiveFile 三大类档案文件
   * @return XfR
   */
  @PatchMapping("/archivefiles/{id}")
  public XfR patchUpdate(@RequestBody ArchiveFile archiveFile,@PathVariable Long id) {
      ArchiveFile uparchiveFile = archiveFileServiceImpl.getById(id);
      if(uparchiveFile != null){
        uparchiveFile = ObjectCopyUtils.copyProperties(archiveFile,uparchiveFile,true);
      }
      return XfR.ok(archiveFileServiceImpl.updateById(uparchiveFile));
  }

  /**
   * 通过id删除三大类档案文件
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/archivefiles/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(archiveFileServiceImpl.removeById(id));
  }

  @PostMapping("/archivefiles/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "archive_file");
     params.put("request", condition);

     return XfR.ok(archiveFileServiceImpl.querys(params));
  }

}
