package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.BaseVoucher;
import com.xforceplus.elephantarchives.service.IBaseVoucherService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-11-12
 */
@RestController
public class BaseVoucherController {

  @Autowired
  private IBaseVoucherService baseVoucherServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param baseVoucher ${table.comment}
   * @return
   */
  @GetMapping("/basevouchers" )
  public XfR getBaseVouchers(XfPage page, BaseVoucher baseVoucher) {
    return XfR.ok(baseVoucherServiceImpl.page(page, Wrappers.query(baseVoucher)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/basevouchers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(baseVoucherServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param baseVoucher ${table.comment}
   * @return XfR
   */
  @PostMapping("/basevouchers")
  public XfR save(@RequestBody BaseVoucher baseVoucher) {
     return XfR.ok(baseVoucherServiceImpl.save(baseVoucher));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param baseVoucher ${table.comment}
   * @return XfR
   */
  @PutMapping("/basevouchers/{id}")
  public XfR putUpdate(@RequestBody BaseVoucher baseVoucher,@PathVariable Long id) {
      baseVoucher.setId(id);
      return XfR.ok(baseVoucherServiceImpl.updateById(baseVoucher));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param baseVoucher ${table.comment}
   * @return XfR
   */
  @PatchMapping("/basevouchers/{id}")
  public XfR patchUpdate(@RequestBody BaseVoucher baseVoucher,@PathVariable Long id) {
      BaseVoucher upbaseVoucher = baseVoucherServiceImpl.getById(id);
      if(upbaseVoucher != null){
        upbaseVoucher = ObjectCopyUtils.copyProperties(baseVoucher,upbaseVoucher,true);
      }
      return XfR.ok(baseVoucherServiceImpl.updateById(upbaseVoucher));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/basevouchers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(baseVoucherServiceImpl.removeById(id));
  }

  @PostMapping("/basevouchers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "base_voucher");
     params.put("request", condition);

     return XfR.ok(baseVoucherServiceImpl.querys(params));
  }

}
