package com.xforceplus.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephantarchives.entity.OriginalTicket;
import com.xforceplus.elephantarchives.service.IOriginalTicketService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 原始单证前端控制器
 *
 * @author ultraman
 * @date 2021-11-12
 */
@RestController
public class OriginalTicketController {

  @Autowired
  private IOriginalTicketService originalTicketServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param originalTicket 原始单证
   * @return
   */
  @GetMapping("/originaltickets" )
  public XfR getOriginalTickets(XfPage page, OriginalTicket originalTicket) {
    return XfR.ok(originalTicketServiceImpl.page(page, Wrappers.query(originalTicket)));
  }

  /**
   * 通过id查询原始单证
   * @param  id
   * @return XfR
   */
  @GetMapping("/originaltickets/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(originalTicketServiceImpl.getById(id));
  }

  /**
   * 新增原始单证
   * @param originalTicket 原始单证
   * @return XfR
   */
  @PostMapping("/originaltickets")
  public XfR save(@RequestBody OriginalTicket originalTicket) {
     return XfR.ok(originalTicketServiceImpl.save(originalTicket));
  }

  /**
   * 修改-传入修改后的全部数据原始单证
   * @param originalTicket 原始单证
   * @return XfR
   */
  @PutMapping("/originaltickets/{id}")
  public XfR putUpdate(@RequestBody OriginalTicket originalTicket,@PathVariable Long id) {
      originalTicket.setId(id);
      return XfR.ok(originalTicketServiceImpl.updateById(originalTicket));
  }

  /**
   * 修改-传入修改的数据原始单证
   * @param originalTicket 原始单证
   * @return XfR
   */
  @PatchMapping("/originaltickets/{id}")
  public XfR patchUpdate(@RequestBody OriginalTicket originalTicket,@PathVariable Long id) {
      OriginalTicket uporiginalTicket = originalTicketServiceImpl.getById(id);
      if(uporiginalTicket != null){
        uporiginalTicket = ObjectCopyUtils.copyProperties(originalTicket,uporiginalTicket,true);
      }
      return XfR.ok(originalTicketServiceImpl.updateById(uporiginalTicket));
  }

  /**
   * 通过id删除原始单证
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/originaltickets/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(originalTicketServiceImpl.removeById(id));
  }

  @PostMapping("/originaltickets/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "original_ticket");
     params.put("request", condition);

     return XfR.ok(originalTicketServiceImpl.querys(params));
  }

}
