package com.xforceplus.elephant.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2021-08-05
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephant.entity.Label;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "elephant")
public interface LabelFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/label/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param label ${table.comment}
   * @return R
   */
  @PostMapping("/label/add")
  public R save(@RequestBody Label label);

  /**
   * 修改${table.comment}
   * @param label ${table.comment}
   * @return R
   */
  @PostMapping("/label/update")
  public R updateById(@RequestBody Label label);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/label/del/{id}" )
  public R removeById(@PathVariable Long id);

}