package com.xforceplus.elephant.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephant.entity.TestBillExt;
import com.xforceplus.elephant.service.ITestBillExtService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-12
 */
@RestController
public class TestBillExtController {

  @Autowired
  private ITestBillExtService testBillExtServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testBillExt ${table.comment}
   * @return
   */
  @GetMapping("/testbillexts" )
  public XfR getTestBillExts(XfPage page, TestBillExt testBillExt) {
    return XfR.ok(testBillExtServiceImpl.page(page, Wrappers.query(testBillExt)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testbillexts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testBillExtServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testBillExt ${table.comment}
   * @return XfR
   */
  @PostMapping("/testbillexts")
  public XfR save(@RequestBody TestBillExt testBillExt) {
     return XfR.ok(testBillExtServiceImpl.save(testBillExt));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testBillExt ${table.comment}
   * @return XfR
   */
  @PutMapping("/testbillexts/{id}")
  public XfR putUpdate(@RequestBody TestBillExt testBillExt,@PathVariable Long id) {
      testBillExt.setId(id);
      return XfR.ok(testBillExtServiceImpl.updateById(testBillExt));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testBillExt ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testbillexts/{id}")
  public XfR patchUpdate(@RequestBody TestBillExt testBillExt,@PathVariable Long id) {
      TestBillExt uptestBillExt = testBillExtServiceImpl.getById(id);
      if(uptestBillExt != null){
        uptestBillExt = ObjectCopyUtils.copyProperties(testBillExt,uptestBillExt,true);
      }
      return XfR.ok(testBillExtServiceImpl.updateById(uptestBillExt));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testbillexts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testBillExtServiceImpl.removeById(id));
  }

  @PostMapping("/testbillexts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test_bill_ext");
     params.put("request", condition);

     return XfR.ok(testBillExtServiceImpl.querys(params));
  }

}
