package com.xforceplus.elephant.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephant.entity.TestSystem;
import com.xforceplus.elephant.service.ITestSystemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-12
 */
@RestController
public class TestSystemController {

  @Autowired
  private ITestSystemService testSystemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testSystem ${table.comment}
   * @return
   */
  @GetMapping("/testsystems" )
  public XfR getTestSystems(XfPage page, TestSystem testSystem) {
    return XfR.ok(testSystemServiceImpl.page(page, Wrappers.query(testSystem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testsystems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testSystemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testSystem ${table.comment}
   * @return XfR
   */
  @PostMapping("/testsystems")
  public XfR save(@RequestBody TestSystem testSystem) {
     return XfR.ok(testSystemServiceImpl.save(testSystem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testSystem ${table.comment}
   * @return XfR
   */
  @PutMapping("/testsystems/{id}")
  public XfR putUpdate(@RequestBody TestSystem testSystem,@PathVariable Long id) {
      testSystem.setId(id);
      return XfR.ok(testSystemServiceImpl.updateById(testSystem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testSystem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testsystems/{id}")
  public XfR patchUpdate(@RequestBody TestSystem testSystem,@PathVariable Long id) {
      TestSystem uptestSystem = testSystemServiceImpl.getById(id);
      if(uptestSystem != null){
        uptestSystem = ObjectCopyUtils.copyProperties(testSystem,uptestSystem,true);
      }
      return XfR.ok(testSystemServiceImpl.updateById(uptestSystem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testsystems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testSystemServiceImpl.removeById(id));
  }

  @PostMapping("/testsystems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test_system");
     params.put("request", condition);

     return XfR.ok(testSystemServiceImpl.querys(params));
  }

}
