package com.xforceplus.elephant.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephant.entity.Testbill;
import com.xforceplus.elephant.service.ITestbillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-12
 */
@RestController
public class TestbillController {

  @Autowired
  private ITestbillService testbillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testbill ${table.comment}
   * @return
   */
  @GetMapping("/testbills" )
  public XfR getTestbills(XfPage page, Testbill testbill) {
    return XfR.ok(testbillServiceImpl.page(page, Wrappers.query(testbill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testbillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testbill ${table.comment}
   * @return XfR
   */
  @PostMapping("/testbills")
  public XfR save(@RequestBody Testbill testbill) {
     return XfR.ok(testbillServiceImpl.save(testbill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testbill ${table.comment}
   * @return XfR
   */
  @PutMapping("/testbills/{id}")
  public XfR putUpdate(@RequestBody Testbill testbill,@PathVariable Long id) {
      testbill.setId(id);
      return XfR.ok(testbillServiceImpl.updateById(testbill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testbill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testbills/{id}")
  public XfR patchUpdate(@RequestBody Testbill testbill,@PathVariable Long id) {
      Testbill uptestbill = testbillServiceImpl.getById(id);
      if(uptestbill != null){
        uptestbill = ObjectCopyUtils.copyProperties(testbill,uptestbill,true);
      }
      return XfR.ok(testbillServiceImpl.updateById(uptestbill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testbillServiceImpl.removeById(id));
  }

  @PostMapping("/testbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testbill");
     params.put("request", condition);

     return XfR.ok(testbillServiceImpl.querys(params));
  }

}
