package com.xforceplus.elephant.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephant.entity.Testbillsub;
import com.xforceplus.elephant.service.ITestbillsubService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-12
 */
@RestController
public class TestbillsubController {

  @Autowired
  private ITestbillsubService testbillsubServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testbillsub ${table.comment}
   * @return
   */
  @GetMapping("/testbillsubs" )
  public XfR getTestbillsubs(XfPage page, Testbillsub testbillsub) {
    return XfR.ok(testbillsubServiceImpl.page(page, Wrappers.query(testbillsub)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testbillsubs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testbillsubServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testbillsub ${table.comment}
   * @return XfR
   */
  @PostMapping("/testbillsubs")
  public XfR save(@RequestBody Testbillsub testbillsub) {
     return XfR.ok(testbillsubServiceImpl.save(testbillsub));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testbillsub ${table.comment}
   * @return XfR
   */
  @PutMapping("/testbillsubs/{id}")
  public XfR putUpdate(@RequestBody Testbillsub testbillsub,@PathVariable Long id) {
      testbillsub.setId(id);
      return XfR.ok(testbillsubServiceImpl.updateById(testbillsub));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testbillsub ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testbillsubs/{id}")
  public XfR patchUpdate(@RequestBody Testbillsub testbillsub,@PathVariable Long id) {
      Testbillsub uptestbillsub = testbillsubServiceImpl.getById(id);
      if(uptestbillsub != null){
        uptestbillsub = ObjectCopyUtils.copyProperties(testbillsub,uptestbillsub,true);
      }
      return XfR.ok(testbillsubServiceImpl.updateById(uptestbillsub));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testbillsubs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testbillsubServiceImpl.removeById(id));
  }

  @PostMapping("/testbillsubs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testbillsub");
     params.put("request", condition);

     return XfR.ok(testbillsubServiceImpl.querys(params));
  }

}
