package com.xforceplus.elephant.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.elephant.entity.TicketMan;
import com.xforceplus.elephant.service.ITicketManService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-12
 */
@RestController
public class TicketManController {

  @Autowired
  private ITicketManService ticketManServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketMan ${table.comment}
   * @return
   */
  @GetMapping("/ticketmans" )
  public XfR getTicketMans(XfPage page, TicketMan ticketMan) {
    return XfR.ok(ticketManServiceImpl.page(page, Wrappers.query(ticketMan)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketmans/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketManServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketMan ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketmans")
  public XfR save(@RequestBody TicketMan ticketMan) {
     return XfR.ok(ticketManServiceImpl.save(ticketMan));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketMan ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketmans/{id}")
  public XfR putUpdate(@RequestBody TicketMan ticketMan,@PathVariable Long id) {
      ticketMan.setId(id);
      return XfR.ok(ticketManServiceImpl.updateById(ticketMan));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketMan ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketmans/{id}")
  public XfR patchUpdate(@RequestBody TicketMan ticketMan,@PathVariable Long id) {
      TicketMan upticketMan = ticketManServiceImpl.getById(id);
      if(upticketMan != null){
        upticketMan = ObjectCopyUtils.copyProperties(ticketMan,upticketMan,true);
      }
      return XfR.ok(ticketManServiceImpl.updateById(upticketMan));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketmans/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketManServiceImpl.removeById(id));
  }

  @PostMapping("/ticketmans/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_man");
     params.put("request", condition);

     return XfR.ok(ticketManServiceImpl.querys(params));
  }

}
