/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.file.ftp;

import com.xforceplus.elephant.basecommon.file.FileStorage;
import com.xforceplus.elephant.basecommon.file.ftp.FTPSettings;
import com.xforceplus.elephant.basecommon.help.FtpHelp;
import java.io.File;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FTPUtils
implements FileStorage {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private FTPSettings ftpSettings;

    @Override
    public String getFileUrl(String key) {
        throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301");
    }

    @Override
    public InputStream getFileInputStream(String key) {
        int index = key.lastIndexOf("/");
        String path = this.ftpSettings.getBasePath() + File.separator + key.substring(0, index);
        String fileName = key.substring(index + 1);
        return FtpHelp.downloadFile(this.ftpSettings.getHost(), this.ftpSettings.getPort(), this.ftpSettings.getUserName(), this.ftpSettings.getPassWord(), path, fileName);
    }

    @Override
    public String uploadFileByInputStream(String key, InputStream content) {
        int index = key.lastIndexOf("/");
        String path = key.substring(0, index);
        String fileName = key.substring(index + 1);
        FtpHelp.uploadFile(this.ftpSettings.getHost(), this.ftpSettings.getPort(), this.ftpSettings.getUserName(), this.ftpSettings.getPassWord(), this.ftpSettings.getBasePath() + File.separator, path, fileName, content);
        return key;
    }

    @Override
    public boolean deleteFiles(String ... keys) {
        boolean result = true;
        for (String key : keys) {
            int index = key.lastIndexOf("/");
            String path = this.ftpSettings.getBasePath() + File.separator + key.substring(0, index);
            String fileName = key.substring(index + 1);
            boolean flag = FtpHelp.deleteFile(this.ftpSettings.getHost(), this.ftpSettings.getPort(), this.ftpSettings.getUserName(), this.ftpSettings.getPassWord(), path, fileName);
            if (flag) continue;
            result = false;
        }
        return result;
    }
}

