/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help;

import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.prometheus.client.SimpleTimer;
import io.prometheus.client.Summary;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class HttpUtils {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JSON = "application/json";
    private static final String DEFAULT_CHARSET = "UTF-8";
    static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private static CloseableHttpClient httpClient;
    private static Summary httpSummary;

    public HttpUtils(PrometheusMeterRegistry prometheusMeterRegistry) {
        httpSummary = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("http_request")).labelNames(new String[]{"url", "method", "type"})).help("http_request Summary.")).register(prometheusMeterRegistry.getPrometheusRegistry());
    }

    @Value(value="${httpTimeOut:10}")
    public static void createClient(int timeout) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
        ConnectionKeepAliveStrategy myStrategy = (response, context) -> {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = it.nextElement();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                return Long.parseLong(value) * 1000L;
            }
            return timeout * 1000;
        };
        try {
            TrustStrategy acceptingTrustStrategy = (cert, authType) -> true;
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)acceptingTrustStrategy).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)new PlainConnectionSocketFactory()).build();
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            connectionManager.setMaxTotal(500);
            connectionManager.setDefaultMaxPerRoute(50);
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setKeepAliveStrategy(myStrategy).setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
            new IdleConnectionMonitorThread((HttpClientConnectionManager)connectionManager).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String doGet(String url, Map<String, String> headers, Map<String, String> params) {
        return HttpUtils.execute(url, "GET", headers, params, null, null);
    }

    public static String doGet(String url, Map<String, String> params) {
        return HttpUtils.execute(url, "GET", null, params, null, null);
    }

    public static String doJsonPost(String url, String json) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(CONTENT_TYPE, APPLICATION_JSON);
        return HttpUtils.execute(url, "POST", headers, null, json, null);
    }

    public static String doJsonPost(String url, Map<String, String> headers, String json) {
        headers.put(CONTENT_TYPE, APPLICATION_JSON);
        return HttpUtils.execute(url, "POST", headers, null, json, null);
    }

    public static String doPost(String url, Map<String, String> headers, Map<String, String> params) {
        return HttpUtils.execute(url, "POST", headers, params, null, null);
    }

    public static String doPost(String url, Map<String, String> headers, Map<String, String> params, String body) {
        return HttpUtils.execute(url, "POST", headers, params, body, null);
    }

    public static String doJsonPut(String url, String json) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(CONTENT_TYPE, APPLICATION_JSON);
        return HttpUtils.execute(url, "PUT", headers, null, json, null);
    }

    public static String doJsonPut(String url, Map<String, String> headers, String json) {
        headers.put(CONTENT_TYPE, APPLICATION_JSON);
        return HttpUtils.execute(url, "PUT", headers, null, json, null);
    }

    public static String doPut(String url, Map<String, String> headers, Map<String, String> params, String body) throws Exception {
        return HttpUtils.execute(url, "PUT", headers, params, body, null);
    }

    public static String doJsonDelete(String url, String json) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(CONTENT_TYPE, APPLICATION_JSON);
        return HttpUtils.execute(url, "DELETE", headers, null, json, null);
    }

    public static String doJsonDelete(String url, Map<String, String> headers, String json) {
        headers.put(CONTENT_TYPE, APPLICATION_JSON);
        return HttpUtils.execute(url, "DELETE", headers, null, json, null);
    }

    public static String doDelete(String url, Map<String, String> headers, Map<String, String> params) {
        return HttpUtils.execute(url, "DELETE", headers, params, null, null);
    }

    public static String doGet(String url) {
        return HttpUtils.execute(url, "GET", null, null, null, null);
    }

    public static InputStream doGetInputStream(String url) {
        byte[] bytes = HttpUtils.executeBytes(url, "GET", null, null, null, null);
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    private static HttpUriRequest request(String url, String method, Map<String, String> headers, Map<String, String> params, String body, Charset charset) {
        RequestBuilder rb = RequestBuilder.create((String)method).setUri(url).setCharset(charset).addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3100.0 Safari/537.36");
        if (ValidatorUtil.isNotEmpty(headers)) {
            headers.entrySet().forEach(entry -> rb.addHeader((String)entry.getKey(), (String)entry.getValue()));
        }
        if (ValidatorUtil.isNotEmpty(params)) {
            params.entrySet().forEach(entry -> rb.addParameter((String)entry.getKey(), (String)entry.getValue()));
        }
        if (ValidatorUtil.isNotEmpty(body)) {
            rb.setEntity((HttpEntity)new StringEntity(body, charset));
        }
        return rb.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String execute(String url, String method, Map<String, String> headers, Map<String, String> params, String body, String charset) {
        String string;
        SimpleTimer requestTimer = new SimpleTimer();
        Charset cs = ValidatorUtil.isNotEmpty(charset) ? Charset.forName(charset) : Charset.defaultCharset();
        HttpUriRequest httpRequest = HttpUtils.request(url, method, headers, params, body, cs);
        try {
            string = (String)httpClient.execute(httpRequest, response -> response.getEntity() != null ? EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)cs) : null);
        }
        catch (IOException e) {
            try {
                logger.error("\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            }
            catch (Throwable throwable) {
                ((Summary.Child)httpSummary.labels(new String[]{url, method, "httpClient"})).observe(requestTimer.elapsedSeconds());
                throw throwable;
            }
            ((Summary.Child)httpSummary.labels(new String[]{url, method, "httpClient"})).observe(requestTimer.elapsedSeconds());
            return null;
        }
        ((Summary.Child)httpSummary.labels(new String[]{url, method, "httpClient"})).observe(requestTimer.elapsedSeconds());
        return string;
    }

    private static byte[] executeBytes(String url, String method, Map<String, String> headers, Map<String, String> params, String body, String charset) {
        Charset cs = ValidatorUtil.isNotEmpty(charset) ? Charset.forName(charset) : Charset.defaultCharset();
        HttpUriRequest httpRequest = HttpUtils.request(url, method, headers, params, body, cs);
        try {
            return (byte[])httpClient.execute(httpRequest, response -> EntityUtils.toByteArray((HttpEntity)response.getEntity()));
        }
        catch (IOException e) {
            logger.error("\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println(HttpUtils.doGet("https://hljgswsbs.gov.cn:9015/api?action=getDoc&code=023002100111_45483698_20220426_G5C4F6I1&type=3"));
    }

    static {
        HttpUtils.createClient(10);
    }

    public static class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager connMgr;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(HttpClientConnectionManager connMgr) {
            this.connMgr = connMgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(5000L);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }
}

