/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.log;

import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.help.TargetUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class StartupListener
implements BeanPostProcessor {
    private static Map<String, Target> regMethods = new HashMap<String, Target>();

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Object realBean = TargetUtils.getTarget(bean);
        Method[] methods = ReflectionUtils.getUniqueDeclaredMethods(realBean.getClass());
        if (methods != null) {
            for (Method method : methods) {
                LogApi logApi = (LogApi)AnnotationUtils.findAnnotation((Method)method, LogApi.class);
                if (null == logApi) continue;
                if (regMethods.containsKey(logApi.methodCode())) {
                    Target target = regMethods.get(logApi.methodCode());
                    String str = String.format("\u3010%s.%s\u3011\u548c\u3010%s.%s\u3011\u5b58\u5728\u91cd\u590dmethodCode:\u3010%s\u3011", realBean.getClass().getName(), target.method.getName(), realBean.getClass().getName(), method.getName(), logApi.methodCode());
                    throw new RuntimeException(str);
                }
                regMethods.put(logApi.methodCode(), new Target(bean, method));
            }
        }
        return bean;
    }

    public static Map<String, Target> getRegMethods() {
        return regMethods;
    }

    public static class Target {
        Object bean;
        Method method;

        public Target(Object bean, Method method) {
            this.bean = bean;
            this.method = method;
        }

        public Object getBean() {
            return this.bean;
        }

        public void setBean(Object bean) {
            this.bean = bean;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }
    }
}

