/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.rabbitmq;

import com.xforceplus.elephant.basecommon.rabbitmq.RabbitmqUtils;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="spring.rabbitmq", name={"enable"}, havingValue="true")
@ConfigurationProperties(value="spring.rabbitmq")
public class RabbitmqSettings {
    private String address;
    private String port;
    private String username;
    private String password;
    private String virtualHost;

    @Bean
    public Queue deadLettersQueue() {
        return new Queue("imageDeadLetterQueue");
    }

    @Bean
    public DirectExchange deadLettersExchange() {
        return new DirectExchange("imageDeadLetterExchange");
    }

    @Bean
    public Binding deadLettersBinding() {
        return BindingBuilder.bind((Queue)this.deadLettersQueue()).to(this.deadLettersExchange()).with("imageDeadLetterQueue");
    }

    @Bean
    public DirectExchange directExchange() {
        return new DirectExchange("directExchange");
    }

    @Bean
    public TopicExchange topicExchange() {
        return new TopicExchange("topicExchange");
    }

    @Bean
    public FanoutExchange fanoutExchange() {
        return new FanoutExchange("fanoutExchange");
    }

    @Bean
    public RabbitmqUtils rabbitmqUtils() {
        return new RabbitmqUtils();
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }
}

