/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.xforceplus.elephant.basecommon.help.image.URLEncoder;
import com.xforceplus.elephant.basecommon.help.image.WaterMarkBO;
import com.xforceplus.elephant.basecommon.help.pdf.PdfWaterMark;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextRenderer;

@Component
public class PdfUtil {
    private static final Logger log = LoggerFactory.getLogger(PdfUtil.class);
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected ResourceLoader resourceLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream createPdf(String content) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ITextRenderer render = new ITextRenderer();
        ITextFontResolver fontResolver = render.getFontResolver();
        try {
            fontResolver.addFont("/template/simhei.ttf", "Identity-H", false);
        }
        catch (DocumentException var16) {
            var16.printStackTrace();
        }
        catch (IOException var17) {
            var17.printStackTrace();
        }
        render.setDocumentFromString(content);
        render.layout();
        try {
            ByteArrayOutputStream var4;
            render.createPDF((OutputStream)outStream);
            ByteArrayOutputStream byteArrayOutputStream = var4 = outStream;
            return byteArrayOutputStream;
        }
        catch (DocumentException var18) {
            var18.printStackTrace();
        }
        finally {
            try {
                outStream.close();
            }
            catch (IOException var15) {
                var15.printStackTrace();
            }
        }
        return null;
    }

    public void yPic(List<BufferedImage> piclist, OutputStream os) {
        if (piclist == null || piclist.size() <= 0) {
            System.out.println("\u56fe\u7247\u6570\u7ec4\u4e3a\u7a7a!");
            return;
        }
        int rows = piclist.size();
        int cols = 1;
        try {
            BufferedImage[] buffImages = new BufferedImage[piclist.size()];
            for (int i = 0; i < piclist.size(); ++i) {
                buffImages[i] = piclist.get(i);
            }
            int type = buffImages[0].getType();
            int chunkWidth = buffImages[0].getWidth();
            int chunkHeight = buffImages[0].getHeight();
            BufferedImage finalImg = new BufferedImage(chunkWidth * cols, chunkHeight * rows, type);
            int num = 0;
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    finalImg.createGraphics().drawImage((Image)buffImages[num], chunkWidth * j, chunkHeight * i, null);
                    ++num;
                }
            }
            this.logger.info("Image concatenated.....");
            ImageIO.write((RenderedImage)finalImg, "png", os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void waterMarkWord(OutputStream out, WaterMarkBO bo) {
        try {
            PdfReader reader = null;
            if (bo.getInputStream() != null) {
                reader = new PdfReader(bo.getInputStream());
            } else {
                String urlStr = StringUtils.replace((String)URLEncoder.DEFAULT.encode(bo.getFileUrl(), Charset.defaultCharset()), (String)"%3F", (String)"?");
                log.info("\u6c34\u5370url\uff1a{}", (Object)urlStr);
                reader = new PdfReader(urlStr);
            }
            PdfStamper stamper = new PdfStamper(reader, out);
            PdfWaterMark.setWatermark(reader, stamper, bo);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void waterMarkWord(String distFile, WaterMarkBO bo) {
        OutputStream out = null;
        try {
            File srcFile = new File(distFile);
            if (!srcFile.getParentFile().exists()) {
                srcFile.getParentFile().mkdirs();
            }
            PdfReader reader = null;
            if (bo.getInputStream() != null) {
                reader = new PdfReader(bo.getInputStream());
            } else {
                String urlStr = StringUtils.replace((String)URLEncoder.DEFAULT.encode(bo.getFileUrl(), Charset.defaultCharset()), (String)"%3F", (String)"?");
                log.info("\u6c34\u5370url\uff1a{}", (Object)urlStr);
                reader = new PdfReader(urlStr);
            }
            out = new FileOutputStream(distFile);
            PdfStamper stamper = new PdfStamper(reader, out);
            PdfWaterMark.setWatermark(reader, stamper, bo);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        String srcFile = "https://mycbtest.bgyfw.com:8090/UpFiles/202210/\u5408\u540c\u767b\u8bb02022_10_20(09_47_57_54)1515151744.pdf";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PdfUtil.waterMarkWord(baos, new WaterMarkBO(srcFile, "\u7968\u6613\u901a", null, null, null));
        System.out.println(baos.size());
    }
}

