/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.monitor;

import com.sensorsdata.analytics.javasdk.ISensorsAnalytics;
import com.sensorsdata.analytics.javasdk.SensorsAnalytics;
import com.sensorsdata.analytics.javasdk.bean.SuperPropertiesRecord;
import com.sensorsdata.analytics.javasdk.consumer.BatchConsumer;
import com.sensorsdata.analytics.javasdk.consumer.Consumer;
import com.sensorsdata.analytics.javasdk.consumer.DebugConsumer;
import com.sensorsdata.analytics.javasdk.exceptions.InvalidArgumentException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="xforce.sensor", name={"enable"}, havingValue="true")
@ConfigurationProperties(value="xforce.sensor")
public class SensorsConfig {
    private String env;
    private String serverUrl;
    private int bulkSize;
    private int timeoutSec;
    private int maxCacheSize;
    private boolean throwException;
    private boolean isDebug;
    private boolean isWriteData;

    @Bean(destroyMethod="shutdown")
    public ISensorsAnalytics init() throws InvalidArgumentException {
        Object consumer = this.isDebug ? new DebugConsumer(this.serverUrl, this.isWriteData) : new BatchConsumer(this.serverUrl, this.bulkSize, this.timeoutSec, this.maxCacheSize, this.throwException);
        SensorsAnalytics sa = new SensorsAnalytics((Consumer)consumer);
        SuperPropertiesRecord propertiesRecord = SuperPropertiesRecord.builder().addProperty("product_line", "\u8fdb\u9879\u4ea7\u54c1\u7ebf").addProperty("product_env", this.env).build();
        sa.registerSuperProperties(propertiesRecord);
        return sa;
    }

    public String getEnv() {
        return this.env;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public int getBulkSize() {
        return this.bulkSize;
    }

    public int getTimeoutSec() {
        return this.timeoutSec;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public boolean isThrowException() {
        return this.throwException;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public boolean isWriteData() {
        return this.isWriteData;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setBulkSize(int bulkSize) {
        this.bulkSize = bulkSize;
    }

    public void setTimeoutSec(int timeoutSec) {
        this.timeoutSec = timeoutSec;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public void setWriteData(boolean isWriteData) {
        this.isWriteData = isWriteData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SensorsConfig)) {
            return false;
        }
        SensorsConfig other = (SensorsConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$env = this.getEnv();
        String other$env = other.getEnv();
        if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
            return false;
        }
        String this$serverUrl = this.getServerUrl();
        String other$serverUrl = other.getServerUrl();
        if (this$serverUrl == null ? other$serverUrl != null : !this$serverUrl.equals(other$serverUrl)) {
            return false;
        }
        if (this.getBulkSize() != other.getBulkSize()) {
            return false;
        }
        if (this.getTimeoutSec() != other.getTimeoutSec()) {
            return false;
        }
        if (this.getMaxCacheSize() != other.getMaxCacheSize()) {
            return false;
        }
        if (this.isThrowException() != other.isThrowException()) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        return this.isWriteData() == other.isWriteData();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SensorsConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        String $serverUrl = this.getServerUrl();
        result = result * 59 + ($serverUrl == null ? 43 : $serverUrl.hashCode());
        result = result * 59 + this.getBulkSize();
        result = result * 59 + this.getTimeoutSec();
        result = result * 59 + this.getMaxCacheSize();
        result = result * 59 + (this.isThrowException() ? 79 : 97);
        result = result * 59 + (this.isDebug() ? 79 : 97);
        result = result * 59 + (this.isWriteData() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "SensorsConfig(env=" + this.getEnv() + ", serverUrl=" + this.getServerUrl() + ", bulkSize=" + this.getBulkSize() + ", timeoutSec=" + this.getTimeoutSec() + ", maxCacheSize=" + this.getMaxCacheSize() + ", throwException=" + this.isThrowException() + ", isDebug=" + this.isDebug() + ", isWriteData=" + this.isWriteData() + ")";
    }
}

