/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.system.bireport;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.xforceplus.elephant.basecommon.help.JsonHelp;
import com.xforceplus.elephant.basecommon.help.OkHttpUtils;
import com.xforceplus.elephant.basecommon.system.bireport.BiApplyRequest;
import com.xforceplus.elephant.basecommon.system.bireport.BiResponse;
import com.xforceplus.elephant.basecommon.system.bireport.ReportDataEntity;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public class BiReportUtils {
    private static final Logger log = LoggerFactory.getLogger(BiReportUtils.class);
    @Value(value="${bi.server.address:http://paas-t.xforceplus.com}")
    private String biHost;
    public static final String BI_API_COMMIT_REQUEST = "/api/report/pentaho/public/report_engine/v1/applyRequest";
    public static final String BI_API_POLL_STATUS = "/api/report/pentaho/public/report_engine/v1/status/%s";
    public static final String BI_API_GET_RESPONSE = "/api/report/pentaho/public/report_engine/v1/execute/%s";
    public static final long POLL_MAX_MILLIS = 300000L;
    public static final long POLL_INTERVAL_MILLIS = 300L;
    public static final String RESPONSE_STATUS_OK = "000000";

    public void fetchBiReport(ReportDataEntity reportData, String token, HttpServletResponse httpServletResponse) throws IOException, InterruptedException {
        String tokenKey = "xforce-saas-token";
        Map<String, Object> commitRequestData = this.commitRequest(reportData, "xforce-saas-token", token);
        String status = commitRequestData.get("status").toString();
        String taskId = commitRequestData.get("uuid").toString();
        if (BiReportUtils.isFinished(status)) {
            this.responseResource(taskId, "xforce-saas-token", token, httpServletResponse);
            return;
        }
        this.pollStatusUntilFinished(taskId, "xforce-saas-token", token, System.currentTimeMillis());
        this.responseResource(taskId, "xforce-saas-token", token, httpServletResponse);
    }

    public ResponseBody getBiResponse(ReportDataEntity reportData, String tokenKey, String token) throws IOException, InterruptedException {
        Map<String, Object> commitRequestData = this.commitRequest(reportData, tokenKey, token);
        String status = commitRequestData.get("status").toString();
        String taskId = commitRequestData.get("uuid").toString();
        if (BiReportUtils.isFinished(status)) {
            return this.responseResource(taskId, tokenKey, token);
        }
        this.pollStatusUntilFinished(taskId, tokenKey, token, System.currentTimeMillis());
        return this.responseResource(taskId, tokenKey, token);
    }

    private Map<String, Object> commitRequest(ReportDataEntity reportData, String tokenKey, String token) throws IOException {
        BiApplyRequest params = BiApplyRequest.builder().code(reportData.getReportCode()).params(reportData.getData()).type(reportData.getRerpotTypeEnum().toString()).build();
        Response response = OkHttpUtils.post(this.biHost + BI_API_COMMIT_REQUEST).header("Content-Type", "application/json").header(tokenKey, token).body(JsonHelp.toString(params)).response();
        return (Map)BiReportUtils.parseBiResponse(response);
    }

    private void pollStatusUntilFinished(String taskId, String tokenKey, String token, long beginTime) throws IOException, InterruptedException {
        if (System.currentTimeMillis() - beginTime > 300000L) {
            throw new RuntimeException("\u67e5\u8be2BI\u62a5\u8868\u8d85\u8fc75\u5206\u949f");
        }
        Thread.sleep(300L);
        Response response = OkHttpUtils.get(this.biHost + String.format(BI_API_POLL_STATUS, taskId)).header("Content-Type", "application/json").header(tokenKey, token).response();
        String status = ((Map)BiReportUtils.parseBiResponse(response)).get("status").toString();
        if (BiReportUtils.isFinished(status)) {
            return;
        }
        if (BiReportUtils.isFailed(status)) {
            throw new RuntimeException("\u62a5\u8868\u5904\u7406\u5931\u8d25");
        }
        if (BiReportUtils.isProcessing(status)) {
            this.pollStatusUntilFinished(taskId, tokenKey, token, beginTime);
        }
    }

    private void responseResource(String taskId, String tokenKey, String token, HttpServletResponse httpServletResponse) throws IOException {
        Response response = OkHttpUtils.get(this.biHost + String.format(BI_API_GET_RESPONSE, taskId)).header("Content-Type", "application/json").header(tokenKey, token).response();
        if (!response.isSuccessful()) {
            log.error("\u83b7\u53d6\u62a5\u8868\u8d44\u6e90\u5931\u8d25");
            throw new RuntimeException(response.message());
        }
        ResponseBody body = response.body();
        httpServletResponse.setContentType(body.contentType().toString());
        httpServletResponse.setCharacterEncoding("UTF-8");
        FileCopyUtils.copy((InputStream)body.byteStream(), (OutputStream)httpServletResponse.getOutputStream());
    }

    private ResponseBody responseResource(String taskId, String tokenKey, String token) {
        HashMap reqHeader = Maps.newHashMap();
        reqHeader.put("Content-Type", "application/json");
        reqHeader.put(tokenKey, token);
        OkHttpUtils.OKRequestBuilder builder = OkHttpUtils.get(this.biHost + String.format(BI_API_GET_RESPONSE, taskId));
        reqHeader.forEach(builder::header);
        Response response = builder.response();
        if (response.isSuccessful()) {
            return response.body();
        }
        throw new RuntimeException(response.message());
    }

    public static boolean isFailed(String status) {
        return "FAILED".equals(status);
    }

    public static boolean isFinished(String status) {
        return "FINISHED".equals(status);
    }

    public static boolean isProcessing(String status) {
        return "QUEUED".equals(status) || "WORKING".equals(status);
    }

    public static Object parseBiResponse(Response response) throws IOException {
        if (!response.isSuccessful()) {
            log.error("\u89e3\u6790\u62a5\u8868\u63a5\u53e3\u8fd4\u56de\u5931\u8d25");
            throw new RuntimeException(response.message());
        }
        String result = new String(response.body().bytes());
        BiResponse biResponse = (BiResponse)JSONObject.parseObject((String)result, BiResponse.class);
        Assert.isTrue((boolean)RESPONSE_STATUS_OK.equals(biResponse.getCode()), (String)("BI\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25:" + biResponse.getMsg()));
        return biResponse.getResult();
    }
}

