/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.system.paas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.baseconst.Constants;
import com.xforceplus.elephant.basecommon.enums.log.ReceiverEnum;
import com.xforceplus.elephant.basecommon.enums.log.SenderEnum;
import com.xforceplus.elephant.basecommon.enums.log.SystemTypeEnum;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.log.MainHeader;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import com.xforceplus.elephant.basecommon.system.paas.DiscernUrlSettings;
import com.xforceplus.elephant.basecommon.system.paas.PaasTokenUtils;
import com.xforceplus.elephant.basecommon.system.paas.SystemPaasSettings;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ImageCloudUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DiscernUrlSettings discernUrlSettings;
    @Autowired
    private PaasTokenUtils paasTokenUtils;
    @Autowired
    private SystemPaasSettings systemPaasSettings;
    @Value(value="${taskModel:1}")
    private int taskModel;

    @LogApi(methodCode="sendOCR", methodDescription="\u53d1\u8d77\u8bc6\u522b", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.MELETE)
    public String invoiceGeneralPro(Integer imageCategory, Long tenantId, Long id, String imageUrl, String suffix) {
        try {
            String url;
            MainHeader mainHeader = MyThreadLocal.setObject(tenantId, tenantId.toString());
            String token = this.paasTokenUtils.getLoginToken();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            JSONObject body = new JSONObject();
            body.put("title", (Object)("\u5f71\u50cf\u8bc6\u522b\u4efb\u52a1" + id));
            body.put("group", (Object)String.valueOf(tenantId));
            body.put("scene", (Object)"4");
            body.put("file", (Object)imageUrl);
            body.put("fileSuffix", (Object)suffix);
            body.put("reserved", (Object)String.valueOf(id));
            body.put("classifierId", (Object)String.valueOf(tenantId));
            if (Constants.NUMBER_TWO.equals(this.taskModel)) {
                body.put("callbackUrl", (Object)this.systemPaasSettings.getOcrCallbackUrl());
                body.put("customerNo", (Object)("imageOCR_" + System.getProperty("env")));
            }
            if (ValidatorUtil.isEmpty(url = this.discernUrlSettings.getSendUrls().get(imageCategory))) {
                url = this.discernUrlSettings.getSendUrls().get(0);
            }
            url = url.replace("{tenant-id}", String.valueOf(tenantId));
            mainHeader.setMethodUrl(url);
            String responseStr = HttpUtils.doPost(url, headers, null, body.toJSONString());
            this.logger.debug("\u53d1\u8d77\u8bc6\u522b\u8bf7\u6c42\u5730\u5740\uff1a\u3010{}\u3011,\u8bf7\u6c42\u5165\u53c2\uff1a\u3010{}\u3011,\u8fd4\u56de\u503c\uff1a\u3010{}\u3011", new Object[]{url, body.toJSONString(), responseStr});
            JSONObject responseObj = JSON.parseObject((String)responseStr);
            if (ValidatorUtil.isEmpty((Map)responseObj)) {
                this.logger.warn("\u53d1\u8d77\u8bc6\u522b\u8bf7\u6c42\u5f02\u5e38");
                mainHeader.fail("\u53d1\u8d77\u8bc6\u522b\u8bf7\u6c42\u5f02\u5e38", responseStr);
                return null;
            }
            String code = responseObj.getString("code");
            if (responseObj.containsKey((Object)"result")) {
                return responseObj.getJSONObject("result").toJSONString();
            }
            this.logger.warn(responseObj.getString("message"));
            mainHeader.fail(responseObj.getString("message"), responseStr);
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u8d77\u5f71\u50cf\u8bc6\u522b\u5931\u8d25", (Throwable)e);
            throw new ElephantException("\u53d1\u8d77\u5f71\u50cf\u8bc6\u522b\u5931\u8d25", (Throwable)e, new Object[0]);
        }
    }

    @LogApi(methodCode="getOCR", methodDescription="\u83b7\u53d6\u8bc6\u522b\u7ed3\u679c", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.MELETE)
    public String getBatchTaskId(Long tenantId, String[] taskIds) {
        try {
            MainHeader mainHeader = MyThreadLocal.setObject(tenantId, tenantId.toString());
            String token = this.paasTokenUtils.getLoginToken();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("batch", Arrays.toString(Arrays.stream(taskIds).map(taskId -> "\"" + taskId + "\"").toArray(String[]::new)));
            String url = this.discernUrlSettings.getGetUrl().replace("{tenant-id}", String.valueOf(tenantId));
            mainHeader.setMethodUrl(url);
            String responseStr = HttpUtils.doGet(url, headers, params);
            JSONObject responseObj = JSON.parseObject((String)responseStr);
            if (ValidatorUtil.isEmpty((Map)responseObj)) {
                this.logger.warn("\u83b7\u53d6\u8bc6\u522b\u7ed3\u679c\u8bf7\u6c42\u5f02\u5e38");
                mainHeader.fail("\u83b7\u53d6\u8bc6\u522b\u7ed3\u679c\u8bf7\u6c42\u5f02\u5e38", responseStr);
                return null;
            }
            String code = responseObj.getString("code");
            if (responseObj.containsKey((Object)"result")) {
                return responseObj.getJSONArray("result").toJSONString();
            }
            this.logger.warn(responseObj.getString("message"));
            mainHeader.fail(responseObj.getString("message"), responseStr);
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5f71\u50cf\u8bc6\u522b\u7ed3\u679c\u5931\u8d25", (Throwable)e);
            throw new ElephantException("\u83b7\u53d6\u5f71\u50cf\u8bc6\u522b\u7ed3\u679c\u5931\u8d25", (Throwable)e, new Object[0]);
        }
    }
}

