/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.rabbitmq;

import com.rabbitmq.client.Channel;
import com.xforceplus.elephant.basecommon.help.RedisUtils;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.io.IOException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RabbitmqAspect {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String MESSAGE_KEY = "elephant:mq:%s";
    public static final String ACKNOWLEDGE_MODE_MANUAL = "manual";
    @Autowired
    private RedisUtils redisUtils;
    @Value(value="${mq.limit.enable:false}")
    private boolean limitEnable;
    @Value(value="${mq.limit.time:1800}")
    private int limitTime;
    @Value(value="${spring.rabbitmq.listener.simple.acknowledge-mode:''}")
    private String manual;

    @Pointcut(value="@annotation(org.springframework.amqp.rabbit.annotation.RabbitListener)")
    public void rabbitMqPoint() {
    }

    @Around(value="rabbitMqPoint()")
    public void afterRun(JoinPoint joinPoint) {
        block18: {
            Message message = null;
            Channel channel = null;
            try {
                String messageId;
                String messageKey;
                block17: {
                    if (null != joinPoint.getArgs()) {
                        for (Object obj : joinPoint.getArgs()) {
                            if (obj instanceof Message) {
                                message = (Message)obj;
                                continue;
                            }
                            if (!(obj instanceof Channel)) continue;
                            channel = (Channel)obj;
                        }
                    }
                    messageKey = null;
                    messageId = null;
                    try {
                        if (null == message || null == channel) break block17;
                        this.logger.info("messageProperties: {}", (Object)message.getMessageProperties());
                        messageId = message.getMessageProperties().getMessageId();
                        if (!this.limitEnable || !ValidatorUtil.isNotEmpty(messageId)) break block17;
                        messageKey = String.format(MESSAGE_KEY, messageId);
                        Object value = this.redisUtils.get(messageKey);
                        this.logger.debug("messageKey:{}, value:{}", (Object)messageKey, value);
                        if (null == value) break block17;
                        this.logger.debug("\u62e6\u622a\u91cd\u590dmessageId:{}", (Object)messageId);
                        try {
                            if (ACKNOWLEDGE_MODE_MANUAL.equalsIgnoreCase(this.manual)) {
                                channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
                                this.logger.debug("\u624b\u52a8ack\u6d88\u606f\uff0cmessageId:{}\uff0cdeliveryTag:{}", (Object)messageId, (Object)message.getMessageProperties().getDeliveryTag());
                            }
                        }
                        catch (IOException e) {
                            this.logger.error("\u624b\u52a8ack\u5f02\u5e38", (Throwable)e);
                        }
                        return;
                    }
                    catch (Exception e) {
                        this.logger.error("mq\u9632\u91cd\u6545\u969c", (Throwable)e);
                    }
                }
                ((ProceedingJoinPoint)joinPoint).proceed();
                if (null == message || null == channel) break block18;
                if (this.limitEnable && ValidatorUtil.isNotEmpty(messageId)) {
                    this.logger.debug("messageId\u5df2\u6210\u529f\u6d88\u8d39:{}", (Object)message.getMessageProperties().getMessageId());
                    this.redisUtils.set(messageKey, true, this.limitTime);
                }
                try {
                    if (ACKNOWLEDGE_MODE_MANUAL.equalsIgnoreCase(this.manual)) {
                        channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
                        this.logger.debug("\u624b\u52a8ack\u6d88\u606f\uff0cmessageId:{}\uff0cdeliveryTag:{}", (Object)messageId, (Object)message.getMessageProperties().getDeliveryTag());
                    }
                }
                catch (IOException e) {
                    this.logger.error("\u624b\u52a8ack\u5f02\u5e38", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                this.logger.error("mq\u5904\u7406\u5f02\u5e38", throwable);
                try {
                    if (null != message && null != channel) {
                        channel.basicNack(message.getMessageProperties().getDeliveryTag(), false, false);
                    }
                }
                catch (IOException e) {
                    this.logger.error("\u8fde\u63a5rabbitmq\u901a\u9053\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                }
            }
        }
    }
}

