/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.file;

import com.xforceplus.elephant.basecommon.enums.common.UploadTypeEnum;
import com.xforceplus.elephant.basecommon.file.FileStorage;
import com.xforceplus.elephant.basecommon.file.ftp.FTPUtils;
import com.xforceplus.elephant.basecommon.file.minio.MinioUtils;
import com.xforceplus.elephant.basecommon.file.oss.OSSUtils;
import com.xforceplus.elephant.basecommon.file.paas.PaasFileUtils;
import com.xforceplus.elephant.basecommon.help.FileUtils;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;

@Component
public class FileManager {
    private static final String UPLOAD_FILE_PATH = "elephant/%s/%s";
    @Value(value="${filestorage.updateType:}")
    private String updateType;
    @Autowired(required=false)
    private OSSUtils ossUtils;
    @Autowired(required=false)
    private FTPUtils ftpUtils;
    @Autowired(required=false)
    private MinioUtils minioUtils;
    @Autowired(required=false)
    private PaasFileUtils paasFileUtils;

    private FileStorage getFileStorage() {
        switch (UploadTypeEnum.valueOf(this.updateType)) {
            case FTP: {
                return this.ftpUtils;
            }
            case OSS: {
                return this.ossUtils;
            }
            case MINIO: {
                return this.minioUtils;
            }
            case PAAS: {
                return this.paasFileUtils;
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u4e0a\u4f20\u65b9\u5f0f");
    }

    public String uploadFile(String fileName, InputStream stream) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        String fileKey = String.format(UPLOAD_FILE_PATH, sdf.format(new Date()), fileName);
        return this.uploadFileByFileKey(fileKey, stream);
    }

    public String uploadFileByFileKey(String fileKey, InputStream stream) {
        String result;
        FileStorage fileStorage = this.getFileStorage();
        if (fileStorage.getFileInputStream(result = fileStorage.uploadFileByInputStream(fileKey, stream)) != null) {
            return result;
        }
        return null;
    }

    public InputStream getFile(String fileKey) {
        FileStorage fileStorage = this.getFileStorage();
        return fileStorage.getFileInputStream(fileKey);
    }

    public String getFileUrl(String fileKey) {
        FileStorage fileStorage = this.getFileStorage();
        String fileUrl = fileStorage.getFileUrl(fileKey);
        fileUrl = this.addMediaType(fileUrl);
        return fileUrl;
    }

    private String addMediaType(String fileUrl) {
        String mediaType;
        String fileSuffix = FileUtils.getFileSuffix(fileUrl);
        if (ValidatorUtil.isEmpty(fileSuffix)) {
            return fileUrl;
        }
        List<String> imageList = Arrays.asList(".jpg", ".jpeg", ".png", ".gif");
        if (imageList.contains(fileSuffix.toLowerCase())) {
            mediaType = "?response-content-type=image/jpg";
            if (fileUrl.contains("?")) {
                mediaType = "&response-content-type=image/jpg";
            }
            fileUrl = fileUrl + mediaType;
        }
        if (fileSuffix.toLowerCase().contains("pdf")) {
            mediaType = "?response-content-type=application/pdf";
            if (fileUrl.contains("?")) {
                mediaType = "&response-content-type=application/pdf";
            }
            fileUrl = fileUrl + mediaType;
        }
        return fileUrl;
    }

    public boolean deleteFile(String ... fileKeys) {
        FileStorage fileStorage = this.getFileStorage();
        return fileStorage.deleteFiles(fileKeys);
    }

    public MediaType mediaType(String fileType) {
        if (ValidatorUtil.isEmpty(fileType)) {
            return MediaType.APPLICATION_OCTET_STREAM;
        }
        if (fileType.toLowerCase().contains("jpg") || fileType.toLowerCase().contains("jpeg")) {
            return MediaType.IMAGE_JPEG;
        }
        if (fileType.toLowerCase().contains("gif")) {
            return MediaType.IMAGE_GIF;
        }
        if (fileType.toLowerCase().contains("png")) {
            return MediaType.IMAGE_PNG;
        }
        if (fileType.toLowerCase().contains("pdf")) {
            return MediaType.APPLICATION_PDF;
        }
        return MediaType.APPLICATION_OCTET_STREAM;
    }
}

