/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Md5Utils {
    private static String NEXT = "->";
    private static String OPENAPI_IMAGE = "OPENAPI_IMAGE";
    private static Logger logger = LoggerFactory.getLogger(Md5Utils.class);

    public static String getOpenapiImageUrlStr(String ... params) {
        if (params == null) {
            return null;
        }
        try {
            StringBuffer sbf = new StringBuffer(OPENAPI_IMAGE);
            String[] strArr = params;
            for (int i = 0; i < params.length; ++i) {
                sbf.append(strArr[i]);
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(sbf.toString().getBytes());
            byte[] digest = md.digest();
            StringBuilder sb = new StringBuilder();
            for (int offset = 0; offset < digest.length; ++offset) {
                int i = digest[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    sb.append(0);
                }
                sb.append(Integer.toHexString(i));
            }
            return sb.toString().toUpperCase();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String excludeKeysFromJson(String reqJSON, String[] excludeKeys) {
        JSONObject jsonObject = (JSONObject)JSON.parseObject((String)reqJSON, JSONObject.class, (Feature[])new Feature[]{Feature.OrderedField});
        if (excludeKeys != null) {
            block0: for (String excludeKey : excludeKeys) {
                String[] keys = excludeKey.split(NEXT);
                JSONObject current = jsonObject;
                for (int i = 0; i < keys.length; ++i) {
                    if (i == keys.length - 1) {
                        current.remove((Object)keys[i]);
                        continue;
                    }
                    Object temp = current.get((Object)keys[i]);
                    if (!(temp instanceof JSONObject)) continue block0;
                    current = (JSONObject)temp;
                }
            }
        }
        return JSON.toJSONString((Object)jsonObject);
    }

    public static String toMD5ExcludesKey(String reqJSON, String ... excludeKeys) {
        try {
            return Md5Utils.jdkMD5(Md5Utils.excludeKeysFromJson(reqJSON, excludeKeys));
        }
        catch (Exception e) {
            logger.error("md5 \u8f6c\u6362\u5931\u8d25");
            return "";
        }
    }

    static String jdkMD5(String src) {
        String res = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] mdBytes = messageDigest.digest(src.getBytes());
            res = DatatypeConverter.printHexBinary((byte[])mdBytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }
}

