/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.xforceplus.elephant.basecommon.help.image.WaterMarkBO;
import com.xforceplus.elephant.basecommon.help.pdf.Font;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.awt.Color;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfWaterMark {
    private static final Logger log = LoggerFactory.getLogger(PdfWaterMark.class);
    private static int interval = 20;

    public static void setWatermark(PdfReader reader, PdfStamper stamper, WaterMarkBO waterMarkBO) {
        try {
            int total = reader.getNumberOfPages() + 1;
            String fontType = waterMarkBO.getFontType();
            BaseFont baseFont = BaseFont.createFont((String)(ValidatorUtil.isEmpty(fontType) ? Font.getSimsun() : fontType), (String)"Identity-H", (boolean)false);
            PdfGState gs = new PdfGState();
            gs.setFillOpacity(0.4f);
            gs.setStrokeOpacity(0.4f);
            int textH = 16;
            int textW = 0;
            if (ValidatorUtil.isNotEmpty(waterMarkBO.getMarkContent())) {
                textW = PdfWaterMark.strWidth(waterMarkBO.getMarkContent());
            }
            Rectangle pageSizeWithRotation = null;
            for (int i = 1; i < total; ++i) {
                PdfContentByte waterMar = stamper.getOverContent(i);
                waterMar.saveState();
                waterMar.setGState(gs);
                waterMar.beginText();
                waterMar.setColorFill(Color.gray);
                waterMar.setFontAndSize(baseFont, ValidatorUtil.isEmpty(waterMarkBO.getFontSize()) ? 14.0f : (float)waterMarkBO.getFontSize().intValue());
                pageSizeWithRotation = reader.getPageSizeWithRotation(i);
                float pageHeight = pageSizeWithRotation.getHeight();
                float pageWidth = pageSizeWithRotation.getWidth();
                if (ValidatorUtil.isNotEmpty(waterMarkBO.getMarkContent())) {
                    int height = 16;
                    while ((float)height < pageHeight) {
                        int width = textW + interval;
                        while ((float)width < pageWidth) {
                            waterMar.showTextAligned(0, waterMarkBO.getMarkContent(), (float)(width - textW), (float)(height - 16), ValidatorUtil.isEmpty(waterMarkBO.getDegree()) ? 30.0f : (float)waterMarkBO.getDegree().intValue());
                            width += textW * 3;
                        }
                        height += 96;
                    }
                } else {
                    waterMar.showTextAligned(0, waterMarkBO.getMarkContent(), pageWidth, pageHeight, ValidatorUtil.isEmpty(waterMarkBO.getDegree()) ? 30.0f : (float)waterMarkBO.getDegree().intValue());
                }
                waterMar.endText();
                waterMar.stroke();
            }
            stamper.close();
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int strWidth(String markContent) {
        int width = 0;
        if (ValidatorUtil.isEmpty(markContent)) {
            return width;
        }
        for (int i = 0; i < markContent.length(); ++i) {
            String a = Character.toString(markContent.charAt(i));
            if (a.matches("^[0-9]$")) {
                width += 7;
                continue;
            }
            if (a.matches("^[A-Z]$")) {
                width += 8;
                continue;
            }
            if (a.matches("^[a-z]$")) {
                width += 6;
                continue;
            }
            if (a.matches("^[\u4e00-\u9fa5]$")) {
                width += 13;
                continue;
            }
            width += 3;
        }
        return width;
    }
}

