/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.pubsub;

import com.alibaba.fastjson.JSON;
import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.apollo.client.utils.SealedMessageBuilder;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.elephant.basecommon.enums.common.YesOrNoEnum;
import com.xforceplus.elephant.basecommon.pubsub.PubSubLogEntity;
import com.xforceplus.elephant.basecommon.rabbitmq.RabbitmqUtils;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PubSubUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired(required=false)
    private MCFactory mcFactory;
    @Autowired(required=false)
    private RabbitmqUtils rabbitmqUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SealedMessage sendSealedMessage(Long tenantId, String description, String requestName, Map<String, String> tags, String message) {
        if (ValidatorUtil.isEmpty(tenantId)) {
            return null;
        }
        if (ValidatorUtil.isEmpty(requestName)) {
            return null;
        }
        if (ValidatorUtil.isEmpty(tags)) {
            return null;
        }
        if (ValidatorUtil.isEmpty(tags.get("payLoadId"))) {
            return null;
        }
        if (ValidatorUtil.isEmpty(message)) {
            return null;
        }
        PubSubLogEntity pubSubLogEntity = new PubSubLogEntity();
        pubSubLogEntity.setError("");
        pubSubLogEntity.setIsSuccessful(YesOrNoEnum.YES.getCode());
        pubSubLogEntity.setDescription(description);
        pubSubLogEntity.setSender("image");
        pubSubLogEntity.setReciver("pubsub");
        pubSubLogEntity.setTenantId(tenantId);
        pubSubLogEntity.setRequestName(requestName);
        pubSubLogEntity.setNumber(tags.get("payLoadId"));
        pubSubLogEntity.setPlayLoadId(tags.get("payLoadId"));
        pubSubLogEntity.setCreateTime(new Date());
        pubSubLogEntity.setType(1);
        try {
            SealedMessage sealedMessage = SealedMessageBuilder.buildSealedMessage((String)requestName, tags, (String)message);
            pubSubLogEntity.setMessage(JSON.toJSONString((Object)sealedMessage));
            this.mcFactory.sendMessage(sealedMessage);
            SealedMessage sealedMessage2 = sealedMessage;
            return sealedMessage2;
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u9001pubsub\u5f02\u5e38", (Throwable)e);
            SealedMessage sealedMessage = null;
            return sealedMessage;
        }
        finally {
            if (null != this.rabbitmqUtils) {
                this.rabbitmqUtils.sendByDirectExchange("imagePubSubLogQueue", pubSubLogEntity);
            }
        }
    }
}

