package com.xforceplus.financialsettlement.controller;


/**
 * 支付流水feign客户端
 *
 * @author ultraman
 * @date 2021-11-18
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.PayWater;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface PayWaterFeignApi {

  /**
   * 通过id查询支付流水
   * @param  id
   * @return R
   */
  @GetMapping("/payWater/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增支付流水
   * @param payWater 支付流水
   * @return R
   */
  @PostMapping("/payWater/add")
  public R save(@RequestBody PayWater payWater);

  /**
   * 修改支付流水
   * @param payWater 支付流水
   * @return R
   */
  @PostMapping("/payWater/update")
  public R updateById(@RequestBody PayWater payWater);

  /**
   * 通过id删除支付流水
   * @param  id
   * @return R
   */
  @DeleteMapping("/payWater/del/{id}" )
  public R removeById(@PathVariable Long id);

}