package com.xforceplus.financialsettlement.controller;


/**
 * 订单feign客户端
 *
 * @author ultraman
 * @date 2021-12-07
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.OrderNo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface OrderNoFeignApi {

  /**
   * 通过id查询订单
   * @param  id
   * @return R
   */
  @GetMapping("/orderNo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增订单
   * @param orderNo 订单
   * @return R
   */
  @PostMapping("/orderNo/add")
  public R save(@RequestBody OrderNo orderNo);

  /**
   * 修改订单
   * @param orderNo 订单
   * @return R
   */
  @PostMapping("/orderNo/update")
  public R updateById(@RequestBody OrderNo orderNo);

  /**
   * 通过id删除订单
   * @param  id
   * @return R
   */
  @DeleteMapping("/orderNo/del/{id}" )
  public R removeById(@PathVariable Long id);

}