package com.xforceplus.financialsettlement.controller;


/**
 * 收入表feign客户端
 *
 * @author ultraman
 * @date 2021-12-15
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.Income;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface IncomeFeignApi {

  /**
   * 通过id查询收入表
   * @param  id
   * @return R
   */
  @GetMapping("/income/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增收入表
   * @param income 收入表
   * @return R
   */
  @PostMapping("/income/add")
  public R save(@RequestBody Income income);

  /**
   * 修改收入表
   * @param income 收入表
   * @return R
   */
  @PostMapping("/income/update")
  public R updateById(@RequestBody Income income);

  /**
   * 通过id删除收入表
   * @param  id
   * @return R
   */
  @DeleteMapping("/income/del/{id}" )
  public R removeById(@PathVariable Long id);

}