package com.xforceplus.financialsettlement.controller;


/**
 * 人员基础信息feign客户端
 *
 * @author ultraman
 * @date 2021-12-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.Member;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface MemberFeignApi {

  /**
   * 通过id查询人员基础信息
   * @param  id
   * @return R
   */
  @GetMapping("/member/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增人员基础信息
   * @param member 人员基础信息
   * @return R
   */
  @PostMapping("/member/add")
  public R save(@RequestBody Member member);

  /**
   * 修改人员基础信息
   * @param member 人员基础信息
   * @return R
   */
  @PostMapping("/member/update")
  public R updateById(@RequestBody Member member);

  /**
   * 通过id删除人员基础信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/member/del/{id}" )
  public R removeById(@PathVariable Long id);

}