package com.xforceplus.financialsettlement.controller;


/**
 * 结算统计明细表feign客户端
 *
 * @author ultraman
 * @date 2021-12-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.SettlementData;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface SettlementDataFeignApi {

  /**
   * 通过id查询结算统计明细表
   * @param  id
   * @return R
   */
  @GetMapping("/settlementData/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增结算统计明细表
   * @param settlementData 结算统计明细表
   * @return R
   */
  @PostMapping("/settlementData/add")
  public R save(@RequestBody SettlementData settlementData);

  /**
   * 修改结算统计明细表
   * @param settlementData 结算统计明细表
   * @return R
   */
  @PostMapping("/settlementData/update")
  public R updateById(@RequestBody SettlementData settlementData);

  /**
   * 通过id删除结算统计明细表
   * @param  id
   * @return R
   */
  @DeleteMapping("/settlementData/del/{id}" )
  public R removeById(@PathVariable Long id);

}