package com.xforceplus.financialsettlement.controller;


/**
 * 结算统计和订单关系feign客户端
 *
 * @author ultraman
 * @date 2021-12-28
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.SettleStaticsOrderRel;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface SettleStaticsOrderRelFeignApi {

  /**
   * 通过id查询结算统计和订单关系
   * @param  id
   * @return R
   */
  @GetMapping("/settleStaticsOrderRel/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增结算统计和订单关系
   * @param settleStaticsOrderRel 结算统计和订单关系
   * @return R
   */
  @PostMapping("/settleStaticsOrderRel/add")
  public R save(@RequestBody SettleStaticsOrderRel settleStaticsOrderRel);

  /**
   * 修改结算统计和订单关系
   * @param settleStaticsOrderRel 结算统计和订单关系
   * @return R
   */
  @PostMapping("/settleStaticsOrderRel/update")
  public R updateById(@RequestBody SettleStaticsOrderRel settleStaticsOrderRel);

  /**
   * 通过id删除结算统计和订单关系
   * @param  id
   * @return R
   */
  @DeleteMapping("/settleStaticsOrderRel/del/{id}" )
  public R removeById(@PathVariable Long id);

}