package com.xforceplus.financialsettlement.controller;


/**
 *  成本编码维护表feign客户端
 *
 * @author ultraman
 * @date 2022-01-06
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.ChargeCodeMaintain;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface ChargeCodeMaintainFeignApi {

  /**
   * 通过id查询 成本编码维护表
   * @param  id
   * @return R
   */
  @GetMapping("/chargeCodeMaintain/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增 成本编码维护表
   * @param chargeCodeMaintain  成本编码维护表
   * @return R
   */
  @PostMapping("/chargeCodeMaintain/add")
  public R save(@RequestBody ChargeCodeMaintain chargeCodeMaintain);

  /**
   * 修改 成本编码维护表
   * @param chargeCodeMaintain  成本编码维护表
   * @return R
   */
  @PostMapping("/chargeCodeMaintain/update")
  public R updateById(@RequestBody ChargeCodeMaintain chargeCodeMaintain);

  /**
   * 通过id删除 成本编码维护表
   * @param  id
   * @return R
   */
  @DeleteMapping("/chargeCodeMaintain/del/{id}" )
  public R removeById(@PathVariable Long id);

}