package com.xforceplus.financialsettlement.controller;


/**
 * 合同主信息feign客户端
 *
 * @author ultraman
 * @date 2022-01-06
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.Contract;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface ContractFeignApi {

  /**
   * 通过id查询合同主信息
   * @param  id
   * @return R
   */
  @GetMapping("/contract/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增合同主信息
   * @param contract 合同主信息
   * @return R
   */
  @PostMapping("/contract/add")
  public R save(@RequestBody Contract contract);

  /**
   * 修改合同主信息
   * @param contract 合同主信息
   * @return R
   */
  @PostMapping("/contract/update")
  public R updateById(@RequestBody Contract contract);

  /**
   * 通过id删除合同主信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/contract/del/{id}" )
  public R removeById(@PathVariable Long id);

}