package com.xforceplus.financialsettlement.controller;


/**
 * 定时任务列表feign客户端
 *
 * @author ultraman
 * @date 2022-01-07
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.JobList;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface JobListFeignApi {

  /**
   * 通过id查询定时任务列表
   * @param  id
   * @return R
   */
  @GetMapping("/jobList/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增定时任务列表
   * @param jobList 定时任务列表
   * @return R
   */
  @PostMapping("/jobList/add")
  public R save(@RequestBody JobList jobList);

  /**
   * 修改定时任务列表
   * @param jobList 定时任务列表
   * @return R
   */
  @PostMapping("/jobList/update")
  public R updateById(@RequestBody JobList jobList);

  /**
   * 通过id删除定时任务列表
   * @param  id
   * @return R
   */
  @DeleteMapping("/jobList/del/{id}" )
  public R removeById(@PathVariable Long id);

}