package com.xforceplus.financialsettlement.controller;


/**
 * 对账单与发票关系feign客户端
 *
 * @author ultraman
 * @date 2022-01-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.financialsettlement.entity.ReconciliationAndInvoiceRelation;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface ReconciliationAndInvoiceRelationFeignApi {

  /**
   * 通过id查询对账单与发票关系
   * @param  id
   * @return R
   */
  @GetMapping("/reconciliationAndInvoiceRelation/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增对账单与发票关系
   * @param reconciliationAndInvoiceRelation 对账单与发票关系
   * @return R
   */
  @PostMapping("/reconciliationAndInvoiceRelation/add")
  public R save(@RequestBody ReconciliationAndInvoiceRelation reconciliationAndInvoiceRelation);

  /**
   * 修改对账单与发票关系
   * @param reconciliationAndInvoiceRelation 对账单与发票关系
   * @return R
   */
  @PostMapping("/reconciliationAndInvoiceRelation/update")
  public R updateById(@RequestBody ReconciliationAndInvoiceRelation reconciliationAndInvoiceRelation);

  /**
   * 通过id删除对账单与发票关系
   * @param  id
   * @return R
   */
  @DeleteMapping("/reconciliationAndInvoiceRelation/del/{id}" )
  public R removeById(@PathVariable Long id);

}